/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CampaignExtensionSettingName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/campaignExtensionSettings/{campaign_extension_setting}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String campaignExtensionSetting;

    public String getCustomer() {
        return this.customer;
    }

    public String getCampaignExtensionSetting() {
        return this.campaignExtensionSetting;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CampaignExtensionSettingName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.campaignExtensionSetting = (String)Preconditions.checkNotNull((Object)builder.getCampaignExtensionSetting());
    }

    public static CampaignExtensionSettingName of(String customer, String campaignExtensionSetting) {
        return CampaignExtensionSettingName.newBuilder().setCustomer(customer).setCampaignExtensionSetting(campaignExtensionSetting).build();
    }

    public static String format(String customer, String campaignExtensionSetting) {
        return CampaignExtensionSettingName.newBuilder().setCustomer(customer).setCampaignExtensionSetting(campaignExtensionSetting).build().toString();
    }

    public static CampaignExtensionSettingName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CampaignExtensionSettingName.parse: formattedString not in valid format");
        return CampaignExtensionSettingName.of((String)matchMap.get("customer"), (String)matchMap.get("campaign_extension_setting"));
    }

    public static List<CampaignExtensionSettingName> parseList(List<String> formattedStrings) {
        ArrayList<CampaignExtensionSettingName> list = new ArrayList<CampaignExtensionSettingName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CampaignExtensionSettingName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CampaignExtensionSettingName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CampaignExtensionSettingName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CampaignExtensionSettingName campaignExtensionSettingName = this;
            synchronized (campaignExtensionSettingName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"campaignExtensionSetting", (Object)this.campaignExtensionSetting);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "campaign_extension_setting", this.campaignExtensionSetting});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CampaignExtensionSettingName) {
            CampaignExtensionSettingName that = (CampaignExtensionSettingName)o;
            return this.customer.equals(that.customer) && this.campaignExtensionSetting.equals(that.campaignExtensionSetting);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.campaignExtensionSetting.hashCode();
    }

    public static class Builder {
        private String customer;
        private String campaignExtensionSetting;

        public String getCustomer() {
            return this.customer;
        }

        public String getCampaignExtensionSetting() {
            return this.campaignExtensionSetting;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setCampaignExtensionSetting(String campaignExtensionSetting) {
            this.campaignExtensionSetting = campaignExtensionSetting;
            return this;
        }

        private Builder() {
        }

        private Builder(CampaignExtensionSettingName campaignExtensionSettingName) {
            this.customer = campaignExtensionSettingName.customer;
            this.campaignExtensionSetting = campaignExtensionSettingName.campaignExtensionSetting;
        }

        public CampaignExtensionSettingName build() {
            return new CampaignExtensionSettingName(this);
        }
    }
}

