/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CampaignFeedName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/campaignFeeds/{campaign_feed}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String campaignFeed;

    public String getCustomer() {
        return this.customer;
    }

    public String getCampaignFeed() {
        return this.campaignFeed;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CampaignFeedName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.campaignFeed = (String)Preconditions.checkNotNull((Object)builder.getCampaignFeed());
    }

    public static CampaignFeedName of(String customer, String campaignFeed) {
        return CampaignFeedName.newBuilder().setCustomer(customer).setCampaignFeed(campaignFeed).build();
    }

    public static String format(String customer, String campaignFeed) {
        return CampaignFeedName.newBuilder().setCustomer(customer).setCampaignFeed(campaignFeed).build().toString();
    }

    public static CampaignFeedName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CampaignFeedName.parse: formattedString not in valid format");
        return CampaignFeedName.of((String)matchMap.get("customer"), (String)matchMap.get("campaign_feed"));
    }

    public static List<CampaignFeedName> parseList(List<String> formattedStrings) {
        ArrayList<CampaignFeedName> list = new ArrayList<CampaignFeedName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CampaignFeedName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CampaignFeedName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CampaignFeedName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CampaignFeedName campaignFeedName = this;
            synchronized (campaignFeedName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"campaignFeed", (Object)this.campaignFeed);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "campaign_feed", this.campaignFeed});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CampaignFeedName) {
            CampaignFeedName that = (CampaignFeedName)o;
            return this.customer.equals(that.customer) && this.campaignFeed.equals(that.campaignFeed);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.campaignFeed.hashCode();
    }

    public static class Builder {
        private String customer;
        private String campaignFeed;

        public String getCustomer() {
            return this.customer;
        }

        public String getCampaignFeed() {
            return this.campaignFeed;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setCampaignFeed(String campaignFeed) {
            this.campaignFeed = campaignFeed;
            return this;
        }

        private Builder() {
        }

        private Builder(CampaignFeedName campaignFeedName) {
            this.customer = campaignFeedName.customer;
            this.campaignFeed = campaignFeedName.campaignFeed;
        }

        public CampaignFeedName build() {
            return new CampaignFeedName(this);
        }
    }
}

