/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CampaignLabelName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/campaignLabels/{campaign_label}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String campaignLabel;

    public String getCustomer() {
        return this.customer;
    }

    public String getCampaignLabel() {
        return this.campaignLabel;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CampaignLabelName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.campaignLabel = (String)Preconditions.checkNotNull((Object)builder.getCampaignLabel());
    }

    public static CampaignLabelName of(String customer, String campaignLabel) {
        return CampaignLabelName.newBuilder().setCustomer(customer).setCampaignLabel(campaignLabel).build();
    }

    public static String format(String customer, String campaignLabel) {
        return CampaignLabelName.newBuilder().setCustomer(customer).setCampaignLabel(campaignLabel).build().toString();
    }

    public static CampaignLabelName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CampaignLabelName.parse: formattedString not in valid format");
        return CampaignLabelName.of((String)matchMap.get("customer"), (String)matchMap.get("campaign_label"));
    }

    public static List<CampaignLabelName> parseList(List<String> formattedStrings) {
        ArrayList<CampaignLabelName> list = new ArrayList<CampaignLabelName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CampaignLabelName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CampaignLabelName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CampaignLabelName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CampaignLabelName campaignLabelName = this;
            synchronized (campaignLabelName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"campaignLabel", (Object)this.campaignLabel);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "campaign_label", this.campaignLabel});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CampaignLabelName) {
            CampaignLabelName that = (CampaignLabelName)o;
            return this.customer.equals(that.customer) && this.campaignLabel.equals(that.campaignLabel);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.campaignLabel.hashCode();
    }

    public static class Builder {
        private String customer;
        private String campaignLabel;

        public String getCustomer() {
            return this.customer;
        }

        public String getCampaignLabel() {
            return this.campaignLabel;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setCampaignLabel(String campaignLabel) {
            this.campaignLabel = campaignLabel;
            return this;
        }

        private Builder() {
        }

        private Builder(CampaignLabelName campaignLabelName) {
            this.customer = campaignLabelName.customer;
            this.campaignLabel = campaignLabelName.campaignLabel;
        }

        public CampaignLabelName build() {
            return new CampaignLabelName(this);
        }
    }
}

