/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.ads.googleads.v5.resources.CampaignLabel;
import com.google.ads.googleads.v5.services.CampaignLabelName;
import com.google.ads.googleads.v5.services.CampaignLabelOperation;
import com.google.ads.googleads.v5.services.CampaignLabelServiceSettings;
import com.google.ads.googleads.v5.services.GetCampaignLabelRequest;
import com.google.ads.googleads.v5.services.MutateCampaignLabelsRequest;
import com.google.ads.googleads.v5.services.MutateCampaignLabelsResponse;
import com.google.ads.googleads.v5.services.stub.CampaignLabelServiceStub;
import com.google.ads.googleads.v5.services.stub.CampaignLabelServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class CampaignLabelServiceClient
implements BackgroundResource {
    private final CampaignLabelServiceSettings settings;
    private final CampaignLabelServiceStub stub;

    public static final CampaignLabelServiceClient create() throws IOException {
        return CampaignLabelServiceClient.create(CampaignLabelServiceSettings.newBuilder().build());
    }

    public static final CampaignLabelServiceClient create(CampaignLabelServiceSettings settings) throws IOException {
        return new CampaignLabelServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CampaignLabelServiceClient create(CampaignLabelServiceStub stub) {
        return new CampaignLabelServiceClient(stub);
    }

    protected CampaignLabelServiceClient(CampaignLabelServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CampaignLabelServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CampaignLabelServiceClient(CampaignLabelServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CampaignLabelServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CampaignLabelServiceStub getStub() {
        return this.stub;
    }

    public final CampaignLabel getCampaignLabel(CampaignLabelName resourceName) {
        GetCampaignLabelRequest request = GetCampaignLabelRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getCampaignLabel(request);
    }

    public final CampaignLabel getCampaignLabel(String resourceName) {
        GetCampaignLabelRequest request = GetCampaignLabelRequest.newBuilder().setResourceName(resourceName).build();
        return this.getCampaignLabel(request);
    }

    public final CampaignLabel getCampaignLabel(GetCampaignLabelRequest request) {
        return (CampaignLabel)this.getCampaignLabelCallable().call((Object)request);
    }

    public final UnaryCallable<GetCampaignLabelRequest, CampaignLabel> getCampaignLabelCallable() {
        return this.stub.getCampaignLabelCallable();
    }

    public final MutateCampaignLabelsResponse mutateCampaignLabels(String customerId, List<CampaignLabelOperation> operations) {
        MutateCampaignLabelsRequest request = MutateCampaignLabelsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateCampaignLabels(request);
    }

    public final MutateCampaignLabelsResponse mutateCampaignLabels(MutateCampaignLabelsRequest request) {
        return (MutateCampaignLabelsResponse)this.mutateCampaignLabelsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateCampaignLabelsRequest, MutateCampaignLabelsResponse> mutateCampaignLabelsCallable() {
        return this.stub.mutateCampaignLabelsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

