/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CampaignName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/campaigns/{campaign}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String campaign;

    public String getCustomer() {
        return this.customer;
    }

    public String getCampaign() {
        return this.campaign;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CampaignName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.campaign = (String)Preconditions.checkNotNull((Object)builder.getCampaign());
    }

    public static CampaignName of(String customer, String campaign) {
        return CampaignName.newBuilder().setCustomer(customer).setCampaign(campaign).build();
    }

    public static String format(String customer, String campaign) {
        return CampaignName.newBuilder().setCustomer(customer).setCampaign(campaign).build().toString();
    }

    public static CampaignName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CampaignName.parse: formattedString not in valid format");
        return CampaignName.of((String)matchMap.get("customer"), (String)matchMap.get("campaign"));
    }

    public static List<CampaignName> parseList(List<String> formattedStrings) {
        ArrayList<CampaignName> list = new ArrayList<CampaignName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CampaignName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CampaignName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CampaignName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CampaignName campaignName = this;
            synchronized (campaignName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"campaign", (Object)this.campaign);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "campaign", this.campaign});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CampaignName) {
            CampaignName that = (CampaignName)o;
            return this.customer.equals(that.customer) && this.campaign.equals(that.campaign);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.campaign.hashCode();
    }

    public static class Builder {
        private String customer;
        private String campaign;

        public String getCustomer() {
            return this.customer;
        }

        public String getCampaign() {
            return this.campaign;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setCampaign(String campaign) {
            this.campaign = campaign;
            return this;
        }

        private Builder() {
        }

        private Builder(CampaignName campaignName) {
            this.customer = campaignName.customer;
            this.campaign = campaignName.campaign;
        }

        public CampaignName build() {
            return new CampaignName(this);
        }
    }
}

