/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CampaignSharedSetName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/campaignSharedSets/{campaign_shared_set}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String campaignSharedSet;

    public String getCustomer() {
        return this.customer;
    }

    public String getCampaignSharedSet() {
        return this.campaignSharedSet;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CampaignSharedSetName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.campaignSharedSet = (String)Preconditions.checkNotNull((Object)builder.getCampaignSharedSet());
    }

    public static CampaignSharedSetName of(String customer, String campaignSharedSet) {
        return CampaignSharedSetName.newBuilder().setCustomer(customer).setCampaignSharedSet(campaignSharedSet).build();
    }

    public static String format(String customer, String campaignSharedSet) {
        return CampaignSharedSetName.newBuilder().setCustomer(customer).setCampaignSharedSet(campaignSharedSet).build().toString();
    }

    public static CampaignSharedSetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CampaignSharedSetName.parse: formattedString not in valid format");
        return CampaignSharedSetName.of((String)matchMap.get("customer"), (String)matchMap.get("campaign_shared_set"));
    }

    public static List<CampaignSharedSetName> parseList(List<String> formattedStrings) {
        ArrayList<CampaignSharedSetName> list = new ArrayList<CampaignSharedSetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CampaignSharedSetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CampaignSharedSetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CampaignSharedSetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CampaignSharedSetName campaignSharedSetName = this;
            synchronized (campaignSharedSetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"campaignSharedSet", (Object)this.campaignSharedSet);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "campaign_shared_set", this.campaignSharedSet});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CampaignSharedSetName) {
            CampaignSharedSetName that = (CampaignSharedSetName)o;
            return this.customer.equals(that.customer) && this.campaignSharedSet.equals(that.campaignSharedSet);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.campaignSharedSet.hashCode();
    }

    public static class Builder {
        private String customer;
        private String campaignSharedSet;

        public String getCustomer() {
            return this.customer;
        }

        public String getCampaignSharedSet() {
            return this.campaignSharedSet;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setCampaignSharedSet(String campaignSharedSet) {
            this.campaignSharedSet = campaignSharedSet;
            return this;
        }

        private Builder() {
        }

        private Builder(CampaignSharedSetName campaignSharedSetName) {
            this.customer = campaignSharedSetName.customer;
            this.campaignSharedSet = campaignSharedSetName.campaignSharedSet;
        }

        public CampaignSharedSetName build() {
            return new CampaignSharedSetName(this);
        }
    }
}

