/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CarrierConstantName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"carrierConstants/{carrier_constant}");
    private volatile Map<String, String> fieldValuesMap;
    private final String carrierConstant;

    public String getCarrierConstant() {
        return this.carrierConstant;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CarrierConstantName(Builder builder) {
        this.carrierConstant = (String)Preconditions.checkNotNull((Object)builder.getCarrierConstant());
    }

    public static CarrierConstantName of(String carrierConstant) {
        return CarrierConstantName.newBuilder().setCarrierConstant(carrierConstant).build();
    }

    public static String format(String carrierConstant) {
        return CarrierConstantName.newBuilder().setCarrierConstant(carrierConstant).build().toString();
    }

    public static CarrierConstantName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CarrierConstantName.parse: formattedString not in valid format");
        return CarrierConstantName.of((String)matchMap.get("carrier_constant"));
    }

    public static List<CarrierConstantName> parseList(List<String> formattedStrings) {
        ArrayList<CarrierConstantName> list = new ArrayList<CarrierConstantName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CarrierConstantName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CarrierConstantName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CarrierConstantName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CarrierConstantName carrierConstantName = this;
            synchronized (carrierConstantName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"carrierConstant", (Object)this.carrierConstant);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"carrier_constant", this.carrierConstant});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CarrierConstantName) {
            CarrierConstantName that = (CarrierConstantName)o;
            return this.carrierConstant.equals(that.carrierConstant);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= this.carrierConstant.hashCode();
    }

    public static class Builder {
        private String carrierConstant;

        public String getCarrierConstant() {
            return this.carrierConstant;
        }

        public Builder setCarrierConstant(String carrierConstant) {
            this.carrierConstant = carrierConstant;
            return this;
        }

        private Builder() {
        }

        private Builder(CarrierConstantName carrierConstantName) {
            this.carrierConstant = carrierConstantName.carrierConstant;
        }

        public CarrierConstantName build() {
            return new CarrierConstantName(this);
        }
    }
}

