/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ChangeStatusName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/changeStatus/{change_status}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String changeStatus;

    public String getCustomer() {
        return this.customer;
    }

    public String getChangeStatus() {
        return this.changeStatus;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ChangeStatusName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.changeStatus = (String)Preconditions.checkNotNull((Object)builder.getChangeStatus());
    }

    public static ChangeStatusName of(String customer, String changeStatus) {
        return ChangeStatusName.newBuilder().setCustomer(customer).setChangeStatus(changeStatus).build();
    }

    public static String format(String customer, String changeStatus) {
        return ChangeStatusName.newBuilder().setCustomer(customer).setChangeStatus(changeStatus).build().toString();
    }

    public static ChangeStatusName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ChangeStatusName.parse: formattedString not in valid format");
        return ChangeStatusName.of((String)matchMap.get("customer"), (String)matchMap.get("change_status"));
    }

    public static List<ChangeStatusName> parseList(List<String> formattedStrings) {
        ArrayList<ChangeStatusName> list = new ArrayList<ChangeStatusName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ChangeStatusName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ChangeStatusName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ChangeStatusName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ChangeStatusName changeStatusName = this;
            synchronized (changeStatusName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"changeStatus", (Object)this.changeStatus);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "change_status", this.changeStatus});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ChangeStatusName) {
            ChangeStatusName that = (ChangeStatusName)o;
            return this.customer.equals(that.customer) && this.changeStatus.equals(that.changeStatus);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.changeStatus.hashCode();
    }

    public static class Builder {
        private String customer;
        private String changeStatus;

        public String getCustomer() {
            return this.customer;
        }

        public String getChangeStatus() {
            return this.changeStatus;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setChangeStatus(String changeStatus) {
            this.changeStatus = changeStatus;
            return this;
        }

        private Builder() {
        }

        private Builder(ChangeStatusName changeStatusName) {
            this.customer = changeStatusName.customer;
            this.changeStatus = changeStatusName.changeStatus;
        }

        public ChangeStatusName build() {
            return new ChangeStatusName(this);
        }
    }
}

