/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.ads.googleads.v5.resources.ChangeStatus;
import com.google.ads.googleads.v5.services.ChangeStatusName;
import com.google.ads.googleads.v5.services.ChangeStatusServiceSettings;
import com.google.ads.googleads.v5.services.GetChangeStatusRequest;
import com.google.ads.googleads.v5.services.stub.ChangeStatusServiceStub;
import com.google.ads.googleads.v5.services.stub.ChangeStatusServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class ChangeStatusServiceClient
implements BackgroundResource {
    private final ChangeStatusServiceSettings settings;
    private final ChangeStatusServiceStub stub;

    public static final ChangeStatusServiceClient create() throws IOException {
        return ChangeStatusServiceClient.create(ChangeStatusServiceSettings.newBuilder().build());
    }

    public static final ChangeStatusServiceClient create(ChangeStatusServiceSettings settings) throws IOException {
        return new ChangeStatusServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ChangeStatusServiceClient create(ChangeStatusServiceStub stub) {
        return new ChangeStatusServiceClient(stub);
    }

    protected ChangeStatusServiceClient(ChangeStatusServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ChangeStatusServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ChangeStatusServiceClient(ChangeStatusServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ChangeStatusServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ChangeStatusServiceStub getStub() {
        return this.stub;
    }

    public final ChangeStatus getChangeStatus(ChangeStatusName resourceName) {
        GetChangeStatusRequest request = GetChangeStatusRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getChangeStatus(request);
    }

    public final ChangeStatus getChangeStatus(String resourceName) {
        GetChangeStatusRequest request = GetChangeStatusRequest.newBuilder().setResourceName(resourceName).build();
        return this.getChangeStatus(request);
    }

    public final ChangeStatus getChangeStatus(GetChangeStatusRequest request) {
        return (ChangeStatus)this.getChangeStatusCallable().call((Object)request);
    }

    public final UnaryCallable<GetChangeStatusRequest, ChangeStatus> getChangeStatusCallable() {
        return this.stub.getChangeStatusCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

