/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ClickViewName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/clickViews/{click_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String clickView;

    public String getCustomer() {
        return this.customer;
    }

    public String getClickView() {
        return this.clickView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ClickViewName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.clickView = (String)Preconditions.checkNotNull((Object)builder.getClickView());
    }

    public static ClickViewName of(String customer, String clickView) {
        return ClickViewName.newBuilder().setCustomer(customer).setClickView(clickView).build();
    }

    public static String format(String customer, String clickView) {
        return ClickViewName.newBuilder().setCustomer(customer).setClickView(clickView).build().toString();
    }

    public static ClickViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ClickViewName.parse: formattedString not in valid format");
        return ClickViewName.of((String)matchMap.get("customer"), (String)matchMap.get("click_view"));
    }

    public static List<ClickViewName> parseList(List<String> formattedStrings) {
        ArrayList<ClickViewName> list = new ArrayList<ClickViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ClickViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ClickViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ClickViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ClickViewName clickViewName = this;
            synchronized (clickViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"clickView", (Object)this.clickView);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "click_view", this.clickView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ClickViewName) {
            ClickViewName that = (ClickViewName)o;
            return this.customer.equals(that.customer) && this.clickView.equals(that.clickView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.clickView.hashCode();
    }

    public static class Builder {
        private String customer;
        private String clickView;

        public String getCustomer() {
            return this.customer;
        }

        public String getClickView() {
            return this.clickView;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setClickView(String clickView) {
            this.clickView = clickView;
            return this;
        }

        private Builder() {
        }

        private Builder(ClickViewName clickViewName) {
            this.customer = clickViewName.customer;
            this.clickView = clickViewName.clickView;
        }

        public ClickViewName build() {
            return new ClickViewName(this);
        }
    }
}

