/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ConversionActionName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/conversionActions/{conversion_action}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String conversionAction;

    public String getCustomer() {
        return this.customer;
    }

    public String getConversionAction() {
        return this.conversionAction;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ConversionActionName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.conversionAction = (String)Preconditions.checkNotNull((Object)builder.getConversionAction());
    }

    public static ConversionActionName of(String customer, String conversionAction) {
        return ConversionActionName.newBuilder().setCustomer(customer).setConversionAction(conversionAction).build();
    }

    public static String format(String customer, String conversionAction) {
        return ConversionActionName.newBuilder().setCustomer(customer).setConversionAction(conversionAction).build().toString();
    }

    public static ConversionActionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ConversionActionName.parse: formattedString not in valid format");
        return ConversionActionName.of((String)matchMap.get("customer"), (String)matchMap.get("conversion_action"));
    }

    public static List<ConversionActionName> parseList(List<String> formattedStrings) {
        ArrayList<ConversionActionName> list = new ArrayList<ConversionActionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ConversionActionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ConversionActionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ConversionActionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ConversionActionName conversionActionName = this;
            synchronized (conversionActionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"conversionAction", (Object)this.conversionAction);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "conversion_action", this.conversionAction});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ConversionActionName) {
            ConversionActionName that = (ConversionActionName)o;
            return this.customer.equals(that.customer) && this.conversionAction.equals(that.conversionAction);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.conversionAction.hashCode();
    }

    public static class Builder {
        private String customer;
        private String conversionAction;

        public String getCustomer() {
            return this.customer;
        }

        public String getConversionAction() {
            return this.conversionAction;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setConversionAction(String conversionAction) {
            this.conversionAction = conversionAction;
            return this;
        }

        private Builder() {
        }

        private Builder(ConversionActionName conversionActionName) {
            this.customer = conversionActionName.customer;
            this.conversionAction = conversionActionName.conversionAction;
        }

        public ConversionActionName build() {
            return new ConversionActionName(this);
        }
    }
}

