/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CurrencyConstantName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"currencyConstants/{currency_constant}");
    private volatile Map<String, String> fieldValuesMap;
    private final String currencyConstant;

    public String getCurrencyConstant() {
        return this.currencyConstant;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CurrencyConstantName(Builder builder) {
        this.currencyConstant = (String)Preconditions.checkNotNull((Object)builder.getCurrencyConstant());
    }

    public static CurrencyConstantName of(String currencyConstant) {
        return CurrencyConstantName.newBuilder().setCurrencyConstant(currencyConstant).build();
    }

    public static String format(String currencyConstant) {
        return CurrencyConstantName.newBuilder().setCurrencyConstant(currencyConstant).build().toString();
    }

    public static CurrencyConstantName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CurrencyConstantName.parse: formattedString not in valid format");
        return CurrencyConstantName.of((String)matchMap.get("currency_constant"));
    }

    public static List<CurrencyConstantName> parseList(List<String> formattedStrings) {
        ArrayList<CurrencyConstantName> list = new ArrayList<CurrencyConstantName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CurrencyConstantName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CurrencyConstantName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CurrencyConstantName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CurrencyConstantName currencyConstantName = this;
            synchronized (currencyConstantName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"currencyConstant", (Object)this.currencyConstant);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"currency_constant", this.currencyConstant});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CurrencyConstantName) {
            CurrencyConstantName that = (CurrencyConstantName)o;
            return this.currencyConstant.equals(that.currencyConstant);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= this.currencyConstant.hashCode();
    }

    public static class Builder {
        private String currencyConstant;

        public String getCurrencyConstant() {
            return this.currencyConstant;
        }

        public Builder setCurrencyConstant(String currencyConstant) {
            this.currencyConstant = currencyConstant;
            return this;
        }

        private Builder() {
        }

        private Builder(CurrencyConstantName currencyConstantName) {
            this.currencyConstant = currencyConstantName.currencyConstant;
        }

        public CurrencyConstantName build() {
            return new CurrencyConstantName(this);
        }
    }
}

