/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CustomInterestName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/customInterests/{custom_interest}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String customInterest;

    public String getCustomer() {
        return this.customer;
    }

    public String getCustomInterest() {
        return this.customInterest;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CustomInterestName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.customInterest = (String)Preconditions.checkNotNull((Object)builder.getCustomInterest());
    }

    public static CustomInterestName of(String customer, String customInterest) {
        return CustomInterestName.newBuilder().setCustomer(customer).setCustomInterest(customInterest).build();
    }

    public static String format(String customer, String customInterest) {
        return CustomInterestName.newBuilder().setCustomer(customer).setCustomInterest(customInterest).build().toString();
    }

    public static CustomInterestName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CustomInterestName.parse: formattedString not in valid format");
        return CustomInterestName.of((String)matchMap.get("customer"), (String)matchMap.get("custom_interest"));
    }

    public static List<CustomInterestName> parseList(List<String> formattedStrings) {
        ArrayList<CustomInterestName> list = new ArrayList<CustomInterestName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomInterestName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomInterestName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomInterestName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomInterestName customInterestName = this;
            synchronized (customInterestName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"customInterest", (Object)this.customInterest);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "custom_interest", this.customInterest});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CustomInterestName) {
            CustomInterestName that = (CustomInterestName)o;
            return this.customer.equals(that.customer) && this.customInterest.equals(that.customInterest);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.customInterest.hashCode();
    }

    public static class Builder {
        private String customer;
        private String customInterest;

        public String getCustomer() {
            return this.customer;
        }

        public String getCustomInterest() {
            return this.customInterest;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setCustomInterest(String customInterest) {
            this.customInterest = customInterest;
            return this;
        }

        private Builder() {
        }

        private Builder(CustomInterestName customInterestName) {
            this.customer = customInterestName.customer;
            this.customInterest = customInterestName.customInterest;
        }

        public CustomInterestName build() {
            return new CustomInterestName(this);
        }
    }
}

