/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CustomerClientLinkName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/customerClientLinks/{customer_client_link}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String customerClientLink;

    public String getCustomer() {
        return this.customer;
    }

    public String getCustomerClientLink() {
        return this.customerClientLink;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CustomerClientLinkName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.customerClientLink = (String)Preconditions.checkNotNull((Object)builder.getCustomerClientLink());
    }

    public static CustomerClientLinkName of(String customer, String customerClientLink) {
        return CustomerClientLinkName.newBuilder().setCustomer(customer).setCustomerClientLink(customerClientLink).build();
    }

    public static String format(String customer, String customerClientLink) {
        return CustomerClientLinkName.newBuilder().setCustomer(customer).setCustomerClientLink(customerClientLink).build().toString();
    }

    public static CustomerClientLinkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CustomerClientLinkName.parse: formattedString not in valid format");
        return CustomerClientLinkName.of((String)matchMap.get("customer"), (String)matchMap.get("customer_client_link"));
    }

    public static List<CustomerClientLinkName> parseList(List<String> formattedStrings) {
        ArrayList<CustomerClientLinkName> list = new ArrayList<CustomerClientLinkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomerClientLinkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomerClientLinkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomerClientLinkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomerClientLinkName customerClientLinkName = this;
            synchronized (customerClientLinkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"customerClientLink", (Object)this.customerClientLink);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "customer_client_link", this.customerClientLink});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CustomerClientLinkName) {
            CustomerClientLinkName that = (CustomerClientLinkName)o;
            return this.customer.equals(that.customer) && this.customerClientLink.equals(that.customerClientLink);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.customerClientLink.hashCode();
    }

    public static class Builder {
        private String customer;
        private String customerClientLink;

        public String getCustomer() {
            return this.customer;
        }

        public String getCustomerClientLink() {
            return this.customerClientLink;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setCustomerClientLink(String customerClientLink) {
            this.customerClientLink = customerClientLink;
            return this;
        }

        private Builder() {
        }

        private Builder(CustomerClientLinkName customerClientLinkName) {
            this.customer = customerClientLinkName.customer;
            this.customerClientLink = customerClientLinkName.customerClientLink;
        }

        public CustomerClientLinkName build() {
            return new CustomerClientLinkName(this);
        }
    }
}

