/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CustomerClientName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/customerClients/{customer_client}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String customerClient;

    public String getCustomer() {
        return this.customer;
    }

    public String getCustomerClient() {
        return this.customerClient;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CustomerClientName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.customerClient = (String)Preconditions.checkNotNull((Object)builder.getCustomerClient());
    }

    public static CustomerClientName of(String customer, String customerClient) {
        return CustomerClientName.newBuilder().setCustomer(customer).setCustomerClient(customerClient).build();
    }

    public static String format(String customer, String customerClient) {
        return CustomerClientName.newBuilder().setCustomer(customer).setCustomerClient(customerClient).build().toString();
    }

    public static CustomerClientName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CustomerClientName.parse: formattedString not in valid format");
        return CustomerClientName.of((String)matchMap.get("customer"), (String)matchMap.get("customer_client"));
    }

    public static List<CustomerClientName> parseList(List<String> formattedStrings) {
        ArrayList<CustomerClientName> list = new ArrayList<CustomerClientName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomerClientName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomerClientName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomerClientName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomerClientName customerClientName = this;
            synchronized (customerClientName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"customerClient", (Object)this.customerClient);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "customer_client", this.customerClient});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CustomerClientName) {
            CustomerClientName that = (CustomerClientName)o;
            return this.customer.equals(that.customer) && this.customerClient.equals(that.customerClient);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.customerClient.hashCode();
    }

    public static class Builder {
        private String customer;
        private String customerClient;

        public String getCustomer() {
            return this.customer;
        }

        public String getCustomerClient() {
            return this.customerClient;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setCustomerClient(String customerClient) {
            this.customerClient = customerClient;
            return this;
        }

        private Builder() {
        }

        private Builder(CustomerClientName customerClientName) {
            this.customer = customerClientName.customer;
            this.customerClient = customerClientName.customerClient;
        }

        public CustomerClientName build() {
            return new CustomerClientName(this);
        }
    }
}

