/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CustomerExtensionSettingName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/customerExtensionSettings/{customer_extension_setting}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String customerExtensionSetting;

    public String getCustomer() {
        return this.customer;
    }

    public String getCustomerExtensionSetting() {
        return this.customerExtensionSetting;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CustomerExtensionSettingName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.customerExtensionSetting = (String)Preconditions.checkNotNull((Object)builder.getCustomerExtensionSetting());
    }

    public static CustomerExtensionSettingName of(String customer, String customerExtensionSetting) {
        return CustomerExtensionSettingName.newBuilder().setCustomer(customer).setCustomerExtensionSetting(customerExtensionSetting).build();
    }

    public static String format(String customer, String customerExtensionSetting) {
        return CustomerExtensionSettingName.newBuilder().setCustomer(customer).setCustomerExtensionSetting(customerExtensionSetting).build().toString();
    }

    public static CustomerExtensionSettingName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CustomerExtensionSettingName.parse: formattedString not in valid format");
        return CustomerExtensionSettingName.of((String)matchMap.get("customer"), (String)matchMap.get("customer_extension_setting"));
    }

    public static List<CustomerExtensionSettingName> parseList(List<String> formattedStrings) {
        ArrayList<CustomerExtensionSettingName> list = new ArrayList<CustomerExtensionSettingName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomerExtensionSettingName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomerExtensionSettingName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomerExtensionSettingName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomerExtensionSettingName customerExtensionSettingName = this;
            synchronized (customerExtensionSettingName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"customerExtensionSetting", (Object)this.customerExtensionSetting);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "customer_extension_setting", this.customerExtensionSetting});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CustomerExtensionSettingName) {
            CustomerExtensionSettingName that = (CustomerExtensionSettingName)o;
            return this.customer.equals(that.customer) && this.customerExtensionSetting.equals(that.customerExtensionSetting);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.customerExtensionSetting.hashCode();
    }

    public static class Builder {
        private String customer;
        private String customerExtensionSetting;

        public String getCustomer() {
            return this.customer;
        }

        public String getCustomerExtensionSetting() {
            return this.customerExtensionSetting;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setCustomerExtensionSetting(String customerExtensionSetting) {
            this.customerExtensionSetting = customerExtensionSetting;
            return this;
        }

        private Builder() {
        }

        private Builder(CustomerExtensionSettingName customerExtensionSettingName) {
            this.customer = customerExtensionSettingName.customer;
            this.customerExtensionSetting = customerExtensionSettingName.customerExtensionSetting;
        }

        public CustomerExtensionSettingName build() {
            return new CustomerExtensionSettingName(this);
        }
    }
}

