/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CustomerFeedName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/customerFeeds/{customer_feed}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String customerFeed;

    public String getCustomer() {
        return this.customer;
    }

    public String getCustomerFeed() {
        return this.customerFeed;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CustomerFeedName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.customerFeed = (String)Preconditions.checkNotNull((Object)builder.getCustomerFeed());
    }

    public static CustomerFeedName of(String customer, String customerFeed) {
        return CustomerFeedName.newBuilder().setCustomer(customer).setCustomerFeed(customerFeed).build();
    }

    public static String format(String customer, String customerFeed) {
        return CustomerFeedName.newBuilder().setCustomer(customer).setCustomerFeed(customerFeed).build().toString();
    }

    public static CustomerFeedName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CustomerFeedName.parse: formattedString not in valid format");
        return CustomerFeedName.of((String)matchMap.get("customer"), (String)matchMap.get("customer_feed"));
    }

    public static List<CustomerFeedName> parseList(List<String> formattedStrings) {
        ArrayList<CustomerFeedName> list = new ArrayList<CustomerFeedName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomerFeedName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomerFeedName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomerFeedName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomerFeedName customerFeedName = this;
            synchronized (customerFeedName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"customerFeed", (Object)this.customerFeed);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "customer_feed", this.customerFeed});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CustomerFeedName) {
            CustomerFeedName that = (CustomerFeedName)o;
            return this.customer.equals(that.customer) && this.customerFeed.equals(that.customerFeed);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.customerFeed.hashCode();
    }

    public static class Builder {
        private String customer;
        private String customerFeed;

        public String getCustomer() {
            return this.customer;
        }

        public String getCustomerFeed() {
            return this.customerFeed;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setCustomerFeed(String customerFeed) {
            this.customerFeed = customerFeed;
            return this;
        }

        private Builder() {
        }

        private Builder(CustomerFeedName customerFeedName) {
            this.customer = customerFeedName.customer;
            this.customerFeed = customerFeedName.customerFeed;
        }

        public CustomerFeedName build() {
            return new CustomerFeedName(this);
        }
    }
}

