/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CustomerLabelName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/customerLabels/{customer_label}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String customerLabel;

    public String getCustomer() {
        return this.customer;
    }

    public String getCustomerLabel() {
        return this.customerLabel;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CustomerLabelName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.customerLabel = (String)Preconditions.checkNotNull((Object)builder.getCustomerLabel());
    }

    public static CustomerLabelName of(String customer, String customerLabel) {
        return CustomerLabelName.newBuilder().setCustomer(customer).setCustomerLabel(customerLabel).build();
    }

    public static String format(String customer, String customerLabel) {
        return CustomerLabelName.newBuilder().setCustomer(customer).setCustomerLabel(customerLabel).build().toString();
    }

    public static CustomerLabelName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CustomerLabelName.parse: formattedString not in valid format");
        return CustomerLabelName.of((String)matchMap.get("customer"), (String)matchMap.get("customer_label"));
    }

    public static List<CustomerLabelName> parseList(List<String> formattedStrings) {
        ArrayList<CustomerLabelName> list = new ArrayList<CustomerLabelName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomerLabelName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomerLabelName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomerLabelName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomerLabelName customerLabelName = this;
            synchronized (customerLabelName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"customerLabel", (Object)this.customerLabel);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "customer_label", this.customerLabel});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CustomerLabelName) {
            CustomerLabelName that = (CustomerLabelName)o;
            return this.customer.equals(that.customer) && this.customerLabel.equals(that.customerLabel);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.customerLabel.hashCode();
    }

    public static class Builder {
        private String customer;
        private String customerLabel;

        public String getCustomer() {
            return this.customer;
        }

        public String getCustomerLabel() {
            return this.customerLabel;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setCustomerLabel(String customerLabel) {
            this.customerLabel = customerLabel;
            return this;
        }

        private Builder() {
        }

        private Builder(CustomerLabelName customerLabelName) {
            this.customer = customerLabelName.customer;
            this.customerLabel = customerLabelName.customerLabel;
        }

        public CustomerLabelName build() {
            return new CustomerLabelName(this);
        }
    }
}

