/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CustomerManagerLinkName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/customerManagerLinks/{customer_manager_link}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String customerManagerLink;

    public String getCustomer() {
        return this.customer;
    }

    public String getCustomerManagerLink() {
        return this.customerManagerLink;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CustomerManagerLinkName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.customerManagerLink = (String)Preconditions.checkNotNull((Object)builder.getCustomerManagerLink());
    }

    public static CustomerManagerLinkName of(String customer, String customerManagerLink) {
        return CustomerManagerLinkName.newBuilder().setCustomer(customer).setCustomerManagerLink(customerManagerLink).build();
    }

    public static String format(String customer, String customerManagerLink) {
        return CustomerManagerLinkName.newBuilder().setCustomer(customer).setCustomerManagerLink(customerManagerLink).build().toString();
    }

    public static CustomerManagerLinkName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CustomerManagerLinkName.parse: formattedString not in valid format");
        return CustomerManagerLinkName.of((String)matchMap.get("customer"), (String)matchMap.get("customer_manager_link"));
    }

    public static List<CustomerManagerLinkName> parseList(List<String> formattedStrings) {
        ArrayList<CustomerManagerLinkName> list = new ArrayList<CustomerManagerLinkName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomerManagerLinkName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomerManagerLinkName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomerManagerLinkName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomerManagerLinkName customerManagerLinkName = this;
            synchronized (customerManagerLinkName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"customerManagerLink", (Object)this.customerManagerLink);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "customer_manager_link", this.customerManagerLink});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CustomerManagerLinkName) {
            CustomerManagerLinkName that = (CustomerManagerLinkName)o;
            return this.customer.equals(that.customer) && this.customerManagerLink.equals(that.customerManagerLink);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.customerManagerLink.hashCode();
    }

    public static class Builder {
        private String customer;
        private String customerManagerLink;

        public String getCustomer() {
            return this.customer;
        }

        public String getCustomerManagerLink() {
            return this.customerManagerLink;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setCustomerManagerLink(String customerManagerLink) {
            this.customerManagerLink = customerManagerLink;
            return this;
        }

        private Builder() {
        }

        private Builder(CustomerManagerLinkName customerManagerLinkName) {
            this.customer = customerManagerLinkName.customer;
            this.customerManagerLink = customerManagerLinkName.customerManagerLink;
        }

        public CustomerManagerLinkName build() {
            return new CustomerManagerLinkName(this);
        }
    }
}

