/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CustomerName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;

    public String getCustomer() {
        return this.customer;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CustomerName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
    }

    public static CustomerName of(String customer) {
        return CustomerName.newBuilder().setCustomer(customer).build();
    }

    public static String format(String customer) {
        return CustomerName.newBuilder().setCustomer(customer).build().toString();
    }

    public static CustomerName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CustomerName.parse: formattedString not in valid format");
        return CustomerName.of((String)matchMap.get("customer"));
    }

    public static List<CustomerName> parseList(List<String> formattedStrings) {
        ArrayList<CustomerName> list = new ArrayList<CustomerName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomerName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomerName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomerName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomerName customerName = this;
            synchronized (customerName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CustomerName) {
            CustomerName that = (CustomerName)o;
            return this.customer.equals(that.customer);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= this.customer.hashCode();
    }

    public static class Builder {
        private String customer;

        public String getCustomer() {
            return this.customer;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        private Builder() {
        }

        private Builder(CustomerName customerName) {
            this.customer = customerName.customer;
        }

        public CustomerName build() {
            return new CustomerName(this);
        }
    }
}

