/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CustomerNegativeCriterionName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/customerNegativeCriteria/{customer_negative_criterion}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String customerNegativeCriterion;

    public String getCustomer() {
        return this.customer;
    }

    public String getCustomerNegativeCriterion() {
        return this.customerNegativeCriterion;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private CustomerNegativeCriterionName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.customerNegativeCriterion = (String)Preconditions.checkNotNull((Object)builder.getCustomerNegativeCriterion());
    }

    public static CustomerNegativeCriterionName of(String customer, String customerNegativeCriterion) {
        return CustomerNegativeCriterionName.newBuilder().setCustomer(customer).setCustomerNegativeCriterion(customerNegativeCriterion).build();
    }

    public static String format(String customer, String customerNegativeCriterion) {
        return CustomerNegativeCriterionName.newBuilder().setCustomer(customer).setCustomerNegativeCriterion(customerNegativeCriterion).build().toString();
    }

    public static CustomerNegativeCriterionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "CustomerNegativeCriterionName.parse: formattedString not in valid format");
        return CustomerNegativeCriterionName.of((String)matchMap.get("customer"), (String)matchMap.get("customer_negative_criterion"));
    }

    public static List<CustomerNegativeCriterionName> parseList(List<String> formattedStrings) {
        ArrayList<CustomerNegativeCriterionName> list = new ArrayList<CustomerNegativeCriterionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomerNegativeCriterionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomerNegativeCriterionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomerNegativeCriterionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomerNegativeCriterionName customerNegativeCriterionName = this;
            synchronized (customerNegativeCriterionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"customerNegativeCriterion", (Object)this.customerNegativeCriterion);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "customer_negative_criterion", this.customerNegativeCriterion});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof CustomerNegativeCriterionName) {
            CustomerNegativeCriterionName that = (CustomerNegativeCriterionName)o;
            return this.customer.equals(that.customer) && this.customerNegativeCriterion.equals(that.customerNegativeCriterion);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.customerNegativeCriterion.hashCode();
    }

    public static class Builder {
        private String customer;
        private String customerNegativeCriterion;

        public String getCustomer() {
            return this.customer;
        }

        public String getCustomerNegativeCriterion() {
            return this.customerNegativeCriterion;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setCustomerNegativeCriterion(String customerNegativeCriterion) {
            this.customerNegativeCriterion = customerNegativeCriterion;
            return this;
        }

        private Builder() {
        }

        private Builder(CustomerNegativeCriterionName customerNegativeCriterionName) {
            this.customer = customerNegativeCriterionName.customer;
            this.customerNegativeCriterion = customerNegativeCriterionName.customerNegativeCriterion;
        }

        public CustomerNegativeCriterionName build() {
            return new CustomerNegativeCriterionName(this);
        }
    }
}

