/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.ads.googleads.v5.resources.Customer;
import com.google.ads.googleads.v5.services.CreateCustomerClientRequest;
import com.google.ads.googleads.v5.services.CreateCustomerClientResponse;
import com.google.ads.googleads.v5.services.CustomerName;
import com.google.ads.googleads.v5.services.CustomerOperation;
import com.google.ads.googleads.v5.services.CustomerServiceSettings;
import com.google.ads.googleads.v5.services.GetCustomerRequest;
import com.google.ads.googleads.v5.services.ListAccessibleCustomersRequest;
import com.google.ads.googleads.v5.services.ListAccessibleCustomersResponse;
import com.google.ads.googleads.v5.services.MutateCustomerRequest;
import com.google.ads.googleads.v5.services.MutateCustomerResponse;
import com.google.ads.googleads.v5.services.stub.CustomerServiceStub;
import com.google.ads.googleads.v5.services.stub.CustomerServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class CustomerServiceClient
implements BackgroundResource {
    private final CustomerServiceSettings settings;
    private final CustomerServiceStub stub;

    public static final CustomerServiceClient create() throws IOException {
        return CustomerServiceClient.create(CustomerServiceSettings.newBuilder().build());
    }

    public static final CustomerServiceClient create(CustomerServiceSettings settings) throws IOException {
        return new CustomerServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CustomerServiceClient create(CustomerServiceStub stub) {
        return new CustomerServiceClient(stub);
    }

    protected CustomerServiceClient(CustomerServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CustomerServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CustomerServiceClient(CustomerServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CustomerServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CustomerServiceStub getStub() {
        return this.stub;
    }

    public final Customer getCustomer(CustomerName resourceName) {
        GetCustomerRequest request = GetCustomerRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getCustomer(request);
    }

    public final Customer getCustomer(String resourceName) {
        GetCustomerRequest request = GetCustomerRequest.newBuilder().setResourceName(resourceName).build();
        return this.getCustomer(request);
    }

    public final Customer getCustomer(GetCustomerRequest request) {
        return (Customer)this.getCustomerCallable().call((Object)request);
    }

    public final UnaryCallable<GetCustomerRequest, Customer> getCustomerCallable() {
        return this.stub.getCustomerCallable();
    }

    public final MutateCustomerResponse mutateCustomer(String customerId, CustomerOperation operation) {
        MutateCustomerRequest request = MutateCustomerRequest.newBuilder().setCustomerId(customerId).setOperation(operation).build();
        return this.mutateCustomer(request);
    }

    public final MutateCustomerResponse mutateCustomer(MutateCustomerRequest request) {
        return (MutateCustomerResponse)this.mutateCustomerCallable().call((Object)request);
    }

    public final UnaryCallable<MutateCustomerRequest, MutateCustomerResponse> mutateCustomerCallable() {
        return this.stub.mutateCustomerCallable();
    }

    public final ListAccessibleCustomersResponse listAccessibleCustomers(ListAccessibleCustomersRequest request) {
        return (ListAccessibleCustomersResponse)this.listAccessibleCustomersCallable().call((Object)request);
    }

    public final UnaryCallable<ListAccessibleCustomersRequest, ListAccessibleCustomersResponse> listAccessibleCustomersCallable() {
        return this.stub.listAccessibleCustomersCallable();
    }

    public final CreateCustomerClientResponse createCustomerClient(String customerId, Customer customerClient) {
        CreateCustomerClientRequest request = CreateCustomerClientRequest.newBuilder().setCustomerId(customerId).setCustomerClient(customerClient).build();
        return this.createCustomerClient(request);
    }

    public final CreateCustomerClientResponse createCustomerClient(CreateCustomerClientRequest request) {
        return (CreateCustomerClientResponse)this.createCustomerClientCallable().call((Object)request);
    }

    public final UnaryCallable<CreateCustomerClientRequest, CreateCustomerClientResponse> createCustomerClientCallable() {
        return this.stub.createCustomerClientCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

