/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DetailPlacementViewName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/detailPlacementViews/{detail_placement_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String detailPlacementView;

    public String getCustomer() {
        return this.customer;
    }

    public String getDetailPlacementView() {
        return this.detailPlacementView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private DetailPlacementViewName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.detailPlacementView = (String)Preconditions.checkNotNull((Object)builder.getDetailPlacementView());
    }

    public static DetailPlacementViewName of(String customer, String detailPlacementView) {
        return DetailPlacementViewName.newBuilder().setCustomer(customer).setDetailPlacementView(detailPlacementView).build();
    }

    public static String format(String customer, String detailPlacementView) {
        return DetailPlacementViewName.newBuilder().setCustomer(customer).setDetailPlacementView(detailPlacementView).build().toString();
    }

    public static DetailPlacementViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "DetailPlacementViewName.parse: formattedString not in valid format");
        return DetailPlacementViewName.of((String)matchMap.get("customer"), (String)matchMap.get("detail_placement_view"));
    }

    public static List<DetailPlacementViewName> parseList(List<String> formattedStrings) {
        ArrayList<DetailPlacementViewName> list = new ArrayList<DetailPlacementViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DetailPlacementViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DetailPlacementViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DetailPlacementViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DetailPlacementViewName detailPlacementViewName = this;
            synchronized (detailPlacementViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"detailPlacementView", (Object)this.detailPlacementView);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "detail_placement_view", this.detailPlacementView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DetailPlacementViewName) {
            DetailPlacementViewName that = (DetailPlacementViewName)o;
            return this.customer.equals(that.customer) && this.detailPlacementView.equals(that.detailPlacementView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.detailPlacementView.hashCode();
    }

    public static class Builder {
        private String customer;
        private String detailPlacementView;

        public String getCustomer() {
            return this.customer;
        }

        public String getDetailPlacementView() {
            return this.detailPlacementView;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setDetailPlacementView(String detailPlacementView) {
            this.detailPlacementView = detailPlacementView;
            return this;
        }

        private Builder() {
        }

        private Builder(DetailPlacementViewName detailPlacementViewName) {
            this.customer = detailPlacementViewName.customer;
            this.detailPlacementView = detailPlacementViewName.detailPlacementView;
        }

        public DetailPlacementViewName build() {
            return new DetailPlacementViewName(this);
        }
    }
}

