/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DisplayKeywordViewName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/displayKeywordViews/{display_keyword_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String displayKeywordView;

    public String getCustomer() {
        return this.customer;
    }

    public String getDisplayKeywordView() {
        return this.displayKeywordView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private DisplayKeywordViewName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.displayKeywordView = (String)Preconditions.checkNotNull((Object)builder.getDisplayKeywordView());
    }

    public static DisplayKeywordViewName of(String customer, String displayKeywordView) {
        return DisplayKeywordViewName.newBuilder().setCustomer(customer).setDisplayKeywordView(displayKeywordView).build();
    }

    public static String format(String customer, String displayKeywordView) {
        return DisplayKeywordViewName.newBuilder().setCustomer(customer).setDisplayKeywordView(displayKeywordView).build().toString();
    }

    public static DisplayKeywordViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "DisplayKeywordViewName.parse: formattedString not in valid format");
        return DisplayKeywordViewName.of((String)matchMap.get("customer"), (String)matchMap.get("display_keyword_view"));
    }

    public static List<DisplayKeywordViewName> parseList(List<String> formattedStrings) {
        ArrayList<DisplayKeywordViewName> list = new ArrayList<DisplayKeywordViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DisplayKeywordViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DisplayKeywordViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DisplayKeywordViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DisplayKeywordViewName displayKeywordViewName = this;
            synchronized (displayKeywordViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"displayKeywordView", (Object)this.displayKeywordView);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "display_keyword_view", this.displayKeywordView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DisplayKeywordViewName) {
            DisplayKeywordViewName that = (DisplayKeywordViewName)o;
            return this.customer.equals(that.customer) && this.displayKeywordView.equals(that.displayKeywordView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.displayKeywordView.hashCode();
    }

    public static class Builder {
        private String customer;
        private String displayKeywordView;

        public String getCustomer() {
            return this.customer;
        }

        public String getDisplayKeywordView() {
            return this.displayKeywordView;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setDisplayKeywordView(String displayKeywordView) {
            this.displayKeywordView = displayKeywordView;
            return this;
        }

        private Builder() {
        }

        private Builder(DisplayKeywordViewName displayKeywordViewName) {
            this.customer = displayKeywordViewName.customer;
            this.displayKeywordView = displayKeywordViewName.displayKeywordView;
        }

        public DisplayKeywordViewName build() {
            return new DisplayKeywordViewName(this);
        }
    }
}

