/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.ads.googleads.v5.resources.DisplayKeywordView;
import com.google.ads.googleads.v5.services.DisplayKeywordViewName;
import com.google.ads.googleads.v5.services.DisplayKeywordViewServiceSettings;
import com.google.ads.googleads.v5.services.GetDisplayKeywordViewRequest;
import com.google.ads.googleads.v5.services.stub.DisplayKeywordViewServiceStub;
import com.google.ads.googleads.v5.services.stub.DisplayKeywordViewServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class DisplayKeywordViewServiceClient
implements BackgroundResource {
    private final DisplayKeywordViewServiceSettings settings;
    private final DisplayKeywordViewServiceStub stub;

    public static final DisplayKeywordViewServiceClient create() throws IOException {
        return DisplayKeywordViewServiceClient.create(DisplayKeywordViewServiceSettings.newBuilder().build());
    }

    public static final DisplayKeywordViewServiceClient create(DisplayKeywordViewServiceSettings settings) throws IOException {
        return new DisplayKeywordViewServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final DisplayKeywordViewServiceClient create(DisplayKeywordViewServiceStub stub) {
        return new DisplayKeywordViewServiceClient(stub);
    }

    protected DisplayKeywordViewServiceClient(DisplayKeywordViewServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DisplayKeywordViewServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected DisplayKeywordViewServiceClient(DisplayKeywordViewServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DisplayKeywordViewServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public DisplayKeywordViewServiceStub getStub() {
        return this.stub;
    }

    public final DisplayKeywordView getDisplayKeywordView(DisplayKeywordViewName resourceName) {
        GetDisplayKeywordViewRequest request = GetDisplayKeywordViewRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getDisplayKeywordView(request);
    }

    public final DisplayKeywordView getDisplayKeywordView(String resourceName) {
        GetDisplayKeywordViewRequest request = GetDisplayKeywordViewRequest.newBuilder().setResourceName(resourceName).build();
        return this.getDisplayKeywordView(request);
    }

    public final DisplayKeywordView getDisplayKeywordView(GetDisplayKeywordViewRequest request) {
        return (DisplayKeywordView)this.getDisplayKeywordViewCallable().call((Object)request);
    }

    public final UnaryCallable<GetDisplayKeywordViewRequest, DisplayKeywordView> getDisplayKeywordViewCallable() {
        return this.stub.getDisplayKeywordViewCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

