/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DistanceViewName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/distanceViews/{distance_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String distanceView;

    public String getCustomer() {
        return this.customer;
    }

    public String getDistanceView() {
        return this.distanceView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private DistanceViewName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.distanceView = (String)Preconditions.checkNotNull((Object)builder.getDistanceView());
    }

    public static DistanceViewName of(String customer, String distanceView) {
        return DistanceViewName.newBuilder().setCustomer(customer).setDistanceView(distanceView).build();
    }

    public static String format(String customer, String distanceView) {
        return DistanceViewName.newBuilder().setCustomer(customer).setDistanceView(distanceView).build().toString();
    }

    public static DistanceViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "DistanceViewName.parse: formattedString not in valid format");
        return DistanceViewName.of((String)matchMap.get("customer"), (String)matchMap.get("distance_view"));
    }

    public static List<DistanceViewName> parseList(List<String> formattedStrings) {
        ArrayList<DistanceViewName> list = new ArrayList<DistanceViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DistanceViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DistanceViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DistanceViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DistanceViewName distanceViewName = this;
            synchronized (distanceViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"distanceView", (Object)this.distanceView);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "distance_view", this.distanceView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DistanceViewName) {
            DistanceViewName that = (DistanceViewName)o;
            return this.customer.equals(that.customer) && this.distanceView.equals(that.distanceView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.distanceView.hashCode();
    }

    public static class Builder {
        private String customer;
        private String distanceView;

        public String getCustomer() {
            return this.customer;
        }

        public String getDistanceView() {
            return this.distanceView;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setDistanceView(String distanceView) {
            this.distanceView = distanceView;
            return this;
        }

        private Builder() {
        }

        private Builder(DistanceViewName distanceViewName) {
            this.customer = distanceViewName.customer;
            this.distanceView = distanceViewName.distanceView;
        }

        public DistanceViewName build() {
            return new DistanceViewName(this);
        }
    }
}

