/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DomainCategoryName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/domainCategories/{domain_category}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String domainCategory;

    public String getCustomer() {
        return this.customer;
    }

    public String getDomainCategory() {
        return this.domainCategory;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private DomainCategoryName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.domainCategory = (String)Preconditions.checkNotNull((Object)builder.getDomainCategory());
    }

    public static DomainCategoryName of(String customer, String domainCategory) {
        return DomainCategoryName.newBuilder().setCustomer(customer).setDomainCategory(domainCategory).build();
    }

    public static String format(String customer, String domainCategory) {
        return DomainCategoryName.newBuilder().setCustomer(customer).setDomainCategory(domainCategory).build().toString();
    }

    public static DomainCategoryName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "DomainCategoryName.parse: formattedString not in valid format");
        return DomainCategoryName.of((String)matchMap.get("customer"), (String)matchMap.get("domain_category"));
    }

    public static List<DomainCategoryName> parseList(List<String> formattedStrings) {
        ArrayList<DomainCategoryName> list = new ArrayList<DomainCategoryName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DomainCategoryName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DomainCategoryName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DomainCategoryName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DomainCategoryName domainCategoryName = this;
            synchronized (domainCategoryName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"domainCategory", (Object)this.domainCategory);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "domain_category", this.domainCategory});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DomainCategoryName) {
            DomainCategoryName that = (DomainCategoryName)o;
            return this.customer.equals(that.customer) && this.domainCategory.equals(that.domainCategory);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.domainCategory.hashCode();
    }

    public static class Builder {
        private String customer;
        private String domainCategory;

        public String getCustomer() {
            return this.customer;
        }

        public String getDomainCategory() {
            return this.domainCategory;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setDomainCategory(String domainCategory) {
            this.domainCategory = domainCategory;
            return this;
        }

        private Builder() {
        }

        private Builder(DomainCategoryName domainCategoryName) {
            this.customer = domainCategoryName.customer;
            this.domainCategory = domainCategoryName.domainCategory;
        }

        public DomainCategoryName build() {
            return new DomainCategoryName(this);
        }
    }
}

