/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DynamicSearchAdsSearchTermViewName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/dynamicSearchAdsSearchTermViews/{dynamic_search_ads_search_term_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String dynamicSearchAdsSearchTermView;

    public String getCustomer() {
        return this.customer;
    }

    public String getDynamicSearchAdsSearchTermView() {
        return this.dynamicSearchAdsSearchTermView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private DynamicSearchAdsSearchTermViewName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.dynamicSearchAdsSearchTermView = (String)Preconditions.checkNotNull((Object)builder.getDynamicSearchAdsSearchTermView());
    }

    public static DynamicSearchAdsSearchTermViewName of(String customer, String dynamicSearchAdsSearchTermView) {
        return DynamicSearchAdsSearchTermViewName.newBuilder().setCustomer(customer).setDynamicSearchAdsSearchTermView(dynamicSearchAdsSearchTermView).build();
    }

    public static String format(String customer, String dynamicSearchAdsSearchTermView) {
        return DynamicSearchAdsSearchTermViewName.newBuilder().setCustomer(customer).setDynamicSearchAdsSearchTermView(dynamicSearchAdsSearchTermView).build().toString();
    }

    public static DynamicSearchAdsSearchTermViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "DynamicSearchAdsSearchTermViewName.parse: formattedString not in valid format");
        return DynamicSearchAdsSearchTermViewName.of((String)matchMap.get("customer"), (String)matchMap.get("dynamic_search_ads_search_term_view"));
    }

    public static List<DynamicSearchAdsSearchTermViewName> parseList(List<String> formattedStrings) {
        ArrayList<DynamicSearchAdsSearchTermViewName> list = new ArrayList<DynamicSearchAdsSearchTermViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(DynamicSearchAdsSearchTermViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<DynamicSearchAdsSearchTermViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (DynamicSearchAdsSearchTermViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            DynamicSearchAdsSearchTermViewName dynamicSearchAdsSearchTermViewName = this;
            synchronized (dynamicSearchAdsSearchTermViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"dynamicSearchAdsSearchTermView", (Object)this.dynamicSearchAdsSearchTermView);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "dynamic_search_ads_search_term_view", this.dynamicSearchAdsSearchTermView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DynamicSearchAdsSearchTermViewName) {
            DynamicSearchAdsSearchTermViewName that = (DynamicSearchAdsSearchTermViewName)o;
            return this.customer.equals(that.customer) && this.dynamicSearchAdsSearchTermView.equals(that.dynamicSearchAdsSearchTermView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.dynamicSearchAdsSearchTermView.hashCode();
    }

    public static class Builder {
        private String customer;
        private String dynamicSearchAdsSearchTermView;

        public String getCustomer() {
            return this.customer;
        }

        public String getDynamicSearchAdsSearchTermView() {
            return this.dynamicSearchAdsSearchTermView;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setDynamicSearchAdsSearchTermView(String dynamicSearchAdsSearchTermView) {
            this.dynamicSearchAdsSearchTermView = dynamicSearchAdsSearchTermView;
            return this;
        }

        private Builder() {
        }

        private Builder(DynamicSearchAdsSearchTermViewName dynamicSearchAdsSearchTermViewName) {
            this.customer = dynamicSearchAdsSearchTermViewName.customer;
            this.dynamicSearchAdsSearchTermView = dynamicSearchAdsSearchTermViewName.dynamicSearchAdsSearchTermView;
        }

        public DynamicSearchAdsSearchTermViewName build() {
            return new DynamicSearchAdsSearchTermViewName(this);
        }
    }
}

