/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ExpandedLandingPageViewName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/expandedLandingPageViews/{expanded_landing_page_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String expandedLandingPageView;

    public String getCustomer() {
        return this.customer;
    }

    public String getExpandedLandingPageView() {
        return this.expandedLandingPageView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ExpandedLandingPageViewName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.expandedLandingPageView = (String)Preconditions.checkNotNull((Object)builder.getExpandedLandingPageView());
    }

    public static ExpandedLandingPageViewName of(String customer, String expandedLandingPageView) {
        return ExpandedLandingPageViewName.newBuilder().setCustomer(customer).setExpandedLandingPageView(expandedLandingPageView).build();
    }

    public static String format(String customer, String expandedLandingPageView) {
        return ExpandedLandingPageViewName.newBuilder().setCustomer(customer).setExpandedLandingPageView(expandedLandingPageView).build().toString();
    }

    public static ExpandedLandingPageViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ExpandedLandingPageViewName.parse: formattedString not in valid format");
        return ExpandedLandingPageViewName.of((String)matchMap.get("customer"), (String)matchMap.get("expanded_landing_page_view"));
    }

    public static List<ExpandedLandingPageViewName> parseList(List<String> formattedStrings) {
        ArrayList<ExpandedLandingPageViewName> list = new ArrayList<ExpandedLandingPageViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ExpandedLandingPageViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ExpandedLandingPageViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ExpandedLandingPageViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ExpandedLandingPageViewName expandedLandingPageViewName = this;
            synchronized (expandedLandingPageViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"expandedLandingPageView", (Object)this.expandedLandingPageView);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "expanded_landing_page_view", this.expandedLandingPageView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ExpandedLandingPageViewName) {
            ExpandedLandingPageViewName that = (ExpandedLandingPageViewName)o;
            return this.customer.equals(that.customer) && this.expandedLandingPageView.equals(that.expandedLandingPageView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.expandedLandingPageView.hashCode();
    }

    public static class Builder {
        private String customer;
        private String expandedLandingPageView;

        public String getCustomer() {
            return this.customer;
        }

        public String getExpandedLandingPageView() {
            return this.expandedLandingPageView;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setExpandedLandingPageView(String expandedLandingPageView) {
            this.expandedLandingPageView = expandedLandingPageView;
            return this;
        }

        private Builder() {
        }

        private Builder(ExpandedLandingPageViewName expandedLandingPageViewName) {
            this.customer = expandedLandingPageViewName.customer;
            this.expandedLandingPageView = expandedLandingPageViewName.expandedLandingPageView;
        }

        public ExpandedLandingPageViewName build() {
            return new ExpandedLandingPageViewName(this);
        }
    }
}

