/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ExtensionFeedItemName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/extensionFeedItems/{extension_feed_item}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String extensionFeedItem;

    public String getCustomer() {
        return this.customer;
    }

    public String getExtensionFeedItem() {
        return this.extensionFeedItem;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ExtensionFeedItemName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.extensionFeedItem = (String)Preconditions.checkNotNull((Object)builder.getExtensionFeedItem());
    }

    public static ExtensionFeedItemName of(String customer, String extensionFeedItem) {
        return ExtensionFeedItemName.newBuilder().setCustomer(customer).setExtensionFeedItem(extensionFeedItem).build();
    }

    public static String format(String customer, String extensionFeedItem) {
        return ExtensionFeedItemName.newBuilder().setCustomer(customer).setExtensionFeedItem(extensionFeedItem).build().toString();
    }

    public static ExtensionFeedItemName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ExtensionFeedItemName.parse: formattedString not in valid format");
        return ExtensionFeedItemName.of((String)matchMap.get("customer"), (String)matchMap.get("extension_feed_item"));
    }

    public static List<ExtensionFeedItemName> parseList(List<String> formattedStrings) {
        ArrayList<ExtensionFeedItemName> list = new ArrayList<ExtensionFeedItemName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ExtensionFeedItemName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ExtensionFeedItemName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ExtensionFeedItemName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ExtensionFeedItemName extensionFeedItemName = this;
            synchronized (extensionFeedItemName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"extensionFeedItem", (Object)this.extensionFeedItem);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "extension_feed_item", this.extensionFeedItem});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ExtensionFeedItemName) {
            ExtensionFeedItemName that = (ExtensionFeedItemName)o;
            return this.customer.equals(that.customer) && this.extensionFeedItem.equals(that.extensionFeedItem);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.extensionFeedItem.hashCode();
    }

    public static class Builder {
        private String customer;
        private String extensionFeedItem;

        public String getCustomer() {
            return this.customer;
        }

        public String getExtensionFeedItem() {
            return this.extensionFeedItem;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setExtensionFeedItem(String extensionFeedItem) {
            this.extensionFeedItem = extensionFeedItem;
            return this;
        }

        private Builder() {
        }

        private Builder(ExtensionFeedItemName extensionFeedItemName) {
            this.customer = extensionFeedItemName.customer;
            this.extensionFeedItem = extensionFeedItemName.extensionFeedItem;
        }

        public ExtensionFeedItemName build() {
            return new ExtensionFeedItemName(this);
        }
    }
}

