/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FeedItemName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/feedItems/{feed_item}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String feedItem;

    public String getCustomer() {
        return this.customer;
    }

    public String getFeedItem() {
        return this.feedItem;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private FeedItemName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.feedItem = (String)Preconditions.checkNotNull((Object)builder.getFeedItem());
    }

    public static FeedItemName of(String customer, String feedItem) {
        return FeedItemName.newBuilder().setCustomer(customer).setFeedItem(feedItem).build();
    }

    public static String format(String customer, String feedItem) {
        return FeedItemName.newBuilder().setCustomer(customer).setFeedItem(feedItem).build().toString();
    }

    public static FeedItemName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "FeedItemName.parse: formattedString not in valid format");
        return FeedItemName.of((String)matchMap.get("customer"), (String)matchMap.get("feed_item"));
    }

    public static List<FeedItemName> parseList(List<String> formattedStrings) {
        ArrayList<FeedItemName> list = new ArrayList<FeedItemName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FeedItemName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FeedItemName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FeedItemName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FeedItemName feedItemName = this;
            synchronized (feedItemName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"feedItem", (Object)this.feedItem);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "feed_item", this.feedItem});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FeedItemName) {
            FeedItemName that = (FeedItemName)o;
            return this.customer.equals(that.customer) && this.feedItem.equals(that.feedItem);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.feedItem.hashCode();
    }

    public static class Builder {
        private String customer;
        private String feedItem;

        public String getCustomer() {
            return this.customer;
        }

        public String getFeedItem() {
            return this.feedItem;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setFeedItem(String feedItem) {
            this.feedItem = feedItem;
            return this;
        }

        private Builder() {
        }

        private Builder(FeedItemName feedItemName) {
            this.customer = feedItemName.customer;
            this.feedItem = feedItemName.feedItem;
        }

        public FeedItemName build() {
            return new FeedItemName(this);
        }
    }
}

