/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FeedItemTargetName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/feedItemTargets/{feed_item_target}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String feedItemTarget;

    public String getCustomer() {
        return this.customer;
    }

    public String getFeedItemTarget() {
        return this.feedItemTarget;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private FeedItemTargetName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.feedItemTarget = (String)Preconditions.checkNotNull((Object)builder.getFeedItemTarget());
    }

    public static FeedItemTargetName of(String customer, String feedItemTarget) {
        return FeedItemTargetName.newBuilder().setCustomer(customer).setFeedItemTarget(feedItemTarget).build();
    }

    public static String format(String customer, String feedItemTarget) {
        return FeedItemTargetName.newBuilder().setCustomer(customer).setFeedItemTarget(feedItemTarget).build().toString();
    }

    public static FeedItemTargetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "FeedItemTargetName.parse: formattedString not in valid format");
        return FeedItemTargetName.of((String)matchMap.get("customer"), (String)matchMap.get("feed_item_target"));
    }

    public static List<FeedItemTargetName> parseList(List<String> formattedStrings) {
        ArrayList<FeedItemTargetName> list = new ArrayList<FeedItemTargetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FeedItemTargetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FeedItemTargetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FeedItemTargetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FeedItemTargetName feedItemTargetName = this;
            synchronized (feedItemTargetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"feedItemTarget", (Object)this.feedItemTarget);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "feed_item_target", this.feedItemTarget});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FeedItemTargetName) {
            FeedItemTargetName that = (FeedItemTargetName)o;
            return this.customer.equals(that.customer) && this.feedItemTarget.equals(that.feedItemTarget);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.feedItemTarget.hashCode();
    }

    public static class Builder {
        private String customer;
        private String feedItemTarget;

        public String getCustomer() {
            return this.customer;
        }

        public String getFeedItemTarget() {
            return this.feedItemTarget;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setFeedItemTarget(String feedItemTarget) {
            this.feedItemTarget = feedItemTarget;
            return this;
        }

        private Builder() {
        }

        private Builder(FeedItemTargetName feedItemTargetName) {
            this.customer = feedItemTargetName.customer;
            this.feedItemTarget = feedItemTargetName.feedItemTarget;
        }

        public FeedItemTargetName build() {
            return new FeedItemTargetName(this);
        }
    }
}

