/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FeedMappingName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/feedMappings/{feed_mapping}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String feedMapping;

    public String getCustomer() {
        return this.customer;
    }

    public String getFeedMapping() {
        return this.feedMapping;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private FeedMappingName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.feedMapping = (String)Preconditions.checkNotNull((Object)builder.getFeedMapping());
    }

    public static FeedMappingName of(String customer, String feedMapping) {
        return FeedMappingName.newBuilder().setCustomer(customer).setFeedMapping(feedMapping).build();
    }

    public static String format(String customer, String feedMapping) {
        return FeedMappingName.newBuilder().setCustomer(customer).setFeedMapping(feedMapping).build().toString();
    }

    public static FeedMappingName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "FeedMappingName.parse: formattedString not in valid format");
        return FeedMappingName.of((String)matchMap.get("customer"), (String)matchMap.get("feed_mapping"));
    }

    public static List<FeedMappingName> parseList(List<String> formattedStrings) {
        ArrayList<FeedMappingName> list = new ArrayList<FeedMappingName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FeedMappingName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FeedMappingName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FeedMappingName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FeedMappingName feedMappingName = this;
            synchronized (feedMappingName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"feedMapping", (Object)this.feedMapping);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "feed_mapping", this.feedMapping});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FeedMappingName) {
            FeedMappingName that = (FeedMappingName)o;
            return this.customer.equals(that.customer) && this.feedMapping.equals(that.feedMapping);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.feedMapping.hashCode();
    }

    public static class Builder {
        private String customer;
        private String feedMapping;

        public String getCustomer() {
            return this.customer;
        }

        public String getFeedMapping() {
            return this.feedMapping;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setFeedMapping(String feedMapping) {
            this.feedMapping = feedMapping;
            return this;
        }

        private Builder() {
        }

        private Builder(FeedMappingName feedMappingName) {
            this.customer = feedMappingName.customer;
            this.feedMapping = feedMappingName.feedMapping;
        }

        public FeedMappingName build() {
            return new FeedMappingName(this);
        }
    }
}

