/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class FeedPlaceholderViewName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/feedPlaceholderViews/{feed_placeholder_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String feedPlaceholderView;

    public String getCustomer() {
        return this.customer;
    }

    public String getFeedPlaceholderView() {
        return this.feedPlaceholderView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private FeedPlaceholderViewName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.feedPlaceholderView = (String)Preconditions.checkNotNull((Object)builder.getFeedPlaceholderView());
    }

    public static FeedPlaceholderViewName of(String customer, String feedPlaceholderView) {
        return FeedPlaceholderViewName.newBuilder().setCustomer(customer).setFeedPlaceholderView(feedPlaceholderView).build();
    }

    public static String format(String customer, String feedPlaceholderView) {
        return FeedPlaceholderViewName.newBuilder().setCustomer(customer).setFeedPlaceholderView(feedPlaceholderView).build().toString();
    }

    public static FeedPlaceholderViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "FeedPlaceholderViewName.parse: formattedString not in valid format");
        return FeedPlaceholderViewName.of((String)matchMap.get("customer"), (String)matchMap.get("feed_placeholder_view"));
    }

    public static List<FeedPlaceholderViewName> parseList(List<String> formattedStrings) {
        ArrayList<FeedPlaceholderViewName> list = new ArrayList<FeedPlaceholderViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FeedPlaceholderViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FeedPlaceholderViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FeedPlaceholderViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FeedPlaceholderViewName feedPlaceholderViewName = this;
            synchronized (feedPlaceholderViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"feedPlaceholderView", (Object)this.feedPlaceholderView);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "feed_placeholder_view", this.feedPlaceholderView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FeedPlaceholderViewName) {
            FeedPlaceholderViewName that = (FeedPlaceholderViewName)o;
            return this.customer.equals(that.customer) && this.feedPlaceholderView.equals(that.feedPlaceholderView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.feedPlaceholderView.hashCode();
    }

    public static class Builder {
        private String customer;
        private String feedPlaceholderView;

        public String getCustomer() {
            return this.customer;
        }

        public String getFeedPlaceholderView() {
            return this.feedPlaceholderView;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setFeedPlaceholderView(String feedPlaceholderView) {
            this.feedPlaceholderView = feedPlaceholderView;
            return this;
        }

        private Builder() {
        }

        private Builder(FeedPlaceholderViewName feedPlaceholderViewName) {
            this.customer = feedPlaceholderViewName.customer;
            this.feedPlaceholderView = feedPlaceholderViewName.feedPlaceholderView;
        }

        public FeedPlaceholderViewName build() {
            return new FeedPlaceholderViewName(this);
        }
    }
}

