/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GenderViewName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/genderViews/{gender_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String genderView;

    public String getCustomer() {
        return this.customer;
    }

    public String getGenderView() {
        return this.genderView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private GenderViewName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.genderView = (String)Preconditions.checkNotNull((Object)builder.getGenderView());
    }

    public static GenderViewName of(String customer, String genderView) {
        return GenderViewName.newBuilder().setCustomer(customer).setGenderView(genderView).build();
    }

    public static String format(String customer, String genderView) {
        return GenderViewName.newBuilder().setCustomer(customer).setGenderView(genderView).build().toString();
    }

    public static GenderViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "GenderViewName.parse: formattedString not in valid format");
        return GenderViewName.of((String)matchMap.get("customer"), (String)matchMap.get("gender_view"));
    }

    public static List<GenderViewName> parseList(List<String> formattedStrings) {
        ArrayList<GenderViewName> list = new ArrayList<GenderViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GenderViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GenderViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GenderViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GenderViewName genderViewName = this;
            synchronized (genderViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"genderView", (Object)this.genderView);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "gender_view", this.genderView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GenderViewName) {
            GenderViewName that = (GenderViewName)o;
            return this.customer.equals(that.customer) && this.genderView.equals(that.genderView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.genderView.hashCode();
    }

    public static class Builder {
        private String customer;
        private String genderView;

        public String getCustomer() {
            return this.customer;
        }

        public String getGenderView() {
            return this.genderView;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setGenderView(String genderView) {
            this.genderView = genderView;
            return this;
        }

        private Builder() {
        }

        private Builder(GenderViewName genderViewName) {
            this.customer = genderViewName.customer;
            this.genderView = genderViewName.genderView;
        }

        public GenderViewName build() {
            return new GenderViewName(this);
        }
    }
}

