/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GeoTargetConstantName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"geoTargetConstants/{geo_target_constant}");
    private volatile Map<String, String> fieldValuesMap;
    private final String geoTargetConstant;

    public String getGeoTargetConstant() {
        return this.geoTargetConstant;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private GeoTargetConstantName(Builder builder) {
        this.geoTargetConstant = (String)Preconditions.checkNotNull((Object)builder.getGeoTargetConstant());
    }

    public static GeoTargetConstantName of(String geoTargetConstant) {
        return GeoTargetConstantName.newBuilder().setGeoTargetConstant(geoTargetConstant).build();
    }

    public static String format(String geoTargetConstant) {
        return GeoTargetConstantName.newBuilder().setGeoTargetConstant(geoTargetConstant).build().toString();
    }

    public static GeoTargetConstantName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "GeoTargetConstantName.parse: formattedString not in valid format");
        return GeoTargetConstantName.of((String)matchMap.get("geo_target_constant"));
    }

    public static List<GeoTargetConstantName> parseList(List<String> formattedStrings) {
        ArrayList<GeoTargetConstantName> list = new ArrayList<GeoTargetConstantName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GeoTargetConstantName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GeoTargetConstantName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GeoTargetConstantName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GeoTargetConstantName geoTargetConstantName = this;
            synchronized (geoTargetConstantName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"geoTargetConstant", (Object)this.geoTargetConstant);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"geo_target_constant", this.geoTargetConstant});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GeoTargetConstantName) {
            GeoTargetConstantName that = (GeoTargetConstantName)o;
            return this.geoTargetConstant.equals(that.geoTargetConstant);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= this.geoTargetConstant.hashCode();
    }

    public static class Builder {
        private String geoTargetConstant;

        public String getGeoTargetConstant() {
            return this.geoTargetConstant;
        }

        public Builder setGeoTargetConstant(String geoTargetConstant) {
            this.geoTargetConstant = geoTargetConstant;
            return this;
        }

        private Builder() {
        }

        private Builder(GeoTargetConstantName geoTargetConstantName) {
            this.geoTargetConstant = geoTargetConstantName.geoTargetConstant;
        }

        public GeoTargetConstantName build() {
            return new GeoTargetConstantName(this);
        }
    }
}

