/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GeographicViewName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/geographicViews/{geographic_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String geographicView;

    public String getCustomer() {
        return this.customer;
    }

    public String getGeographicView() {
        return this.geographicView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private GeographicViewName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.geographicView = (String)Preconditions.checkNotNull((Object)builder.getGeographicView());
    }

    public static GeographicViewName of(String customer, String geographicView) {
        return GeographicViewName.newBuilder().setCustomer(customer).setGeographicView(geographicView).build();
    }

    public static String format(String customer, String geographicView) {
        return GeographicViewName.newBuilder().setCustomer(customer).setGeographicView(geographicView).build().toString();
    }

    public static GeographicViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "GeographicViewName.parse: formattedString not in valid format");
        return GeographicViewName.of((String)matchMap.get("customer"), (String)matchMap.get("geographic_view"));
    }

    public static List<GeographicViewName> parseList(List<String> formattedStrings) {
        ArrayList<GeographicViewName> list = new ArrayList<GeographicViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GeographicViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GeographicViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GeographicViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GeographicViewName geographicViewName = this;
            synchronized (geographicViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"geographicView", (Object)this.geographicView);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "geographic_view", this.geographicView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GeographicViewName) {
            GeographicViewName that = (GeographicViewName)o;
            return this.customer.equals(that.customer) && this.geographicView.equals(that.geographicView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.geographicView.hashCode();
    }

    public static class Builder {
        private String customer;
        private String geographicView;

        public String getCustomer() {
            return this.customer;
        }

        public String getGeographicView() {
            return this.geographicView;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setGeographicView(String geographicView) {
            this.geographicView = geographicView;
            return this;
        }

        private Builder() {
        }

        private Builder(GeographicViewName geographicViewName) {
            this.customer = geographicViewName.customer;
            this.geographicView = geographicViewName.geographicView;
        }

        public GeographicViewName build() {
            return new GeographicViewName(this);
        }
    }
}

