/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GroupPlacementViewName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/groupPlacementViews/{group_placement_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String groupPlacementView;

    public String getCustomer() {
        return this.customer;
    }

    public String getGroupPlacementView() {
        return this.groupPlacementView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private GroupPlacementViewName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.groupPlacementView = (String)Preconditions.checkNotNull((Object)builder.getGroupPlacementView());
    }

    public static GroupPlacementViewName of(String customer, String groupPlacementView) {
        return GroupPlacementViewName.newBuilder().setCustomer(customer).setGroupPlacementView(groupPlacementView).build();
    }

    public static String format(String customer, String groupPlacementView) {
        return GroupPlacementViewName.newBuilder().setCustomer(customer).setGroupPlacementView(groupPlacementView).build().toString();
    }

    public static GroupPlacementViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "GroupPlacementViewName.parse: formattedString not in valid format");
        return GroupPlacementViewName.of((String)matchMap.get("customer"), (String)matchMap.get("group_placement_view"));
    }

    public static List<GroupPlacementViewName> parseList(List<String> formattedStrings) {
        ArrayList<GroupPlacementViewName> list = new ArrayList<GroupPlacementViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(GroupPlacementViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<GroupPlacementViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (GroupPlacementViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            GroupPlacementViewName groupPlacementViewName = this;
            synchronized (groupPlacementViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"groupPlacementView", (Object)this.groupPlacementView);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "group_placement_view", this.groupPlacementView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GroupPlacementViewName) {
            GroupPlacementViewName that = (GroupPlacementViewName)o;
            return this.customer.equals(that.customer) && this.groupPlacementView.equals(that.groupPlacementView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.groupPlacementView.hashCode();
    }

    public static class Builder {
        private String customer;
        private String groupPlacementView;

        public String getCustomer() {
            return this.customer;
        }

        public String getGroupPlacementView() {
            return this.groupPlacementView;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setGroupPlacementView(String groupPlacementView) {
            this.groupPlacementView = groupPlacementView;
            return this;
        }

        private Builder() {
        }

        private Builder(GroupPlacementViewName groupPlacementViewName) {
            this.customer = groupPlacementViewName.customer;
            this.groupPlacementView = groupPlacementViewName.groupPlacementView;
        }

        public GroupPlacementViewName build() {
            return new GroupPlacementViewName(this);
        }
    }
}

