/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HotelGroupViewName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/hotelGroupViews/{hotel_group_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String hotelGroupView;

    public String getCustomer() {
        return this.customer;
    }

    public String getHotelGroupView() {
        return this.hotelGroupView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private HotelGroupViewName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.hotelGroupView = (String)Preconditions.checkNotNull((Object)builder.getHotelGroupView());
    }

    public static HotelGroupViewName of(String customer, String hotelGroupView) {
        return HotelGroupViewName.newBuilder().setCustomer(customer).setHotelGroupView(hotelGroupView).build();
    }

    public static String format(String customer, String hotelGroupView) {
        return HotelGroupViewName.newBuilder().setCustomer(customer).setHotelGroupView(hotelGroupView).build().toString();
    }

    public static HotelGroupViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "HotelGroupViewName.parse: formattedString not in valid format");
        return HotelGroupViewName.of((String)matchMap.get("customer"), (String)matchMap.get("hotel_group_view"));
    }

    public static List<HotelGroupViewName> parseList(List<String> formattedStrings) {
        ArrayList<HotelGroupViewName> list = new ArrayList<HotelGroupViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(HotelGroupViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<HotelGroupViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (HotelGroupViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            HotelGroupViewName hotelGroupViewName = this;
            synchronized (hotelGroupViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"hotelGroupView", (Object)this.hotelGroupView);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "hotel_group_view", this.hotelGroupView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HotelGroupViewName) {
            HotelGroupViewName that = (HotelGroupViewName)o;
            return this.customer.equals(that.customer) && this.hotelGroupView.equals(that.hotelGroupView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.hotelGroupView.hashCode();
    }

    public static class Builder {
        private String customer;
        private String hotelGroupView;

        public String getCustomer() {
            return this.customer;
        }

        public String getHotelGroupView() {
            return this.hotelGroupView;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setHotelGroupView(String hotelGroupView) {
            this.hotelGroupView = hotelGroupView;
            return this;
        }

        private Builder() {
        }

        private Builder(HotelGroupViewName hotelGroupViewName) {
            this.customer = hotelGroupViewName.customer;
            this.hotelGroupView = hotelGroupViewName.hotelGroupView;
        }

        public HotelGroupViewName build() {
            return new HotelGroupViewName(this);
        }
    }
}

