/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class IncomeRangeViewName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/incomeRangeViews/{income_range_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String incomeRangeView;

    public String getCustomer() {
        return this.customer;
    }

    public String getIncomeRangeView() {
        return this.incomeRangeView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private IncomeRangeViewName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.incomeRangeView = (String)Preconditions.checkNotNull((Object)builder.getIncomeRangeView());
    }

    public static IncomeRangeViewName of(String customer, String incomeRangeView) {
        return IncomeRangeViewName.newBuilder().setCustomer(customer).setIncomeRangeView(incomeRangeView).build();
    }

    public static String format(String customer, String incomeRangeView) {
        return IncomeRangeViewName.newBuilder().setCustomer(customer).setIncomeRangeView(incomeRangeView).build().toString();
    }

    public static IncomeRangeViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "IncomeRangeViewName.parse: formattedString not in valid format");
        return IncomeRangeViewName.of((String)matchMap.get("customer"), (String)matchMap.get("income_range_view"));
    }

    public static List<IncomeRangeViewName> parseList(List<String> formattedStrings) {
        ArrayList<IncomeRangeViewName> list = new ArrayList<IncomeRangeViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(IncomeRangeViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<IncomeRangeViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (IncomeRangeViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            IncomeRangeViewName incomeRangeViewName = this;
            synchronized (incomeRangeViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"incomeRangeView", (Object)this.incomeRangeView);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "income_range_view", this.incomeRangeView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IncomeRangeViewName) {
            IncomeRangeViewName that = (IncomeRangeViewName)o;
            return this.customer.equals(that.customer) && this.incomeRangeView.equals(that.incomeRangeView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.incomeRangeView.hashCode();
    }

    public static class Builder {
        private String customer;
        private String incomeRangeView;

        public String getCustomer() {
            return this.customer;
        }

        public String getIncomeRangeView() {
            return this.incomeRangeView;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setIncomeRangeView(String incomeRangeView) {
            this.incomeRangeView = incomeRangeView;
            return this;
        }

        private Builder() {
        }

        private Builder(IncomeRangeViewName incomeRangeViewName) {
            this.customer = incomeRangeViewName.customer;
            this.incomeRangeView = incomeRangeViewName.incomeRangeView;
        }

        public IncomeRangeViewName build() {
            return new IncomeRangeViewName(this);
        }
    }
}

