/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InvoiceName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/invoices/{invoice}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String invoice;

    public String getCustomer() {
        return this.customer;
    }

    public String getInvoice() {
        return this.invoice;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private InvoiceName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.invoice = (String)Preconditions.checkNotNull((Object)builder.getInvoice());
    }

    public static InvoiceName of(String customer, String invoice) {
        return InvoiceName.newBuilder().setCustomer(customer).setInvoice(invoice).build();
    }

    public static String format(String customer, String invoice) {
        return InvoiceName.newBuilder().setCustomer(customer).setInvoice(invoice).build().toString();
    }

    public static InvoiceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "InvoiceName.parse: formattedString not in valid format");
        return InvoiceName.of((String)matchMap.get("customer"), (String)matchMap.get("invoice"));
    }

    public static List<InvoiceName> parseList(List<String> formattedStrings) {
        ArrayList<InvoiceName> list = new ArrayList<InvoiceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(InvoiceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<InvoiceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (InvoiceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            InvoiceName invoiceName = this;
            synchronized (invoiceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"invoice", (Object)this.invoice);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "invoice", this.invoice});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof InvoiceName) {
            InvoiceName that = (InvoiceName)o;
            return this.customer.equals(that.customer) && this.invoice.equals(that.invoice);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.invoice.hashCode();
    }

    public static class Builder {
        private String customer;
        private String invoice;

        public String getCustomer() {
            return this.customer;
        }

        public String getInvoice() {
            return this.invoice;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setInvoice(String invoice) {
            this.invoice = invoice;
            return this;
        }

        private Builder() {
        }

        private Builder(InvoiceName invoiceName) {
            this.customer = invoiceName.customer;
            this.invoice = invoiceName.invoice;
        }

        public InvoiceName build() {
            return new InvoiceName(this);
        }
    }
}

