/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class KeywordPlanAdGroupKeywordName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/keywordPlanAdGroupKeywords/{keyword_plan_ad_group_keyword}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String keywordPlanAdGroupKeyword;

    public String getCustomer() {
        return this.customer;
    }

    public String getKeywordPlanAdGroupKeyword() {
        return this.keywordPlanAdGroupKeyword;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private KeywordPlanAdGroupKeywordName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.keywordPlanAdGroupKeyword = (String)Preconditions.checkNotNull((Object)builder.getKeywordPlanAdGroupKeyword());
    }

    public static KeywordPlanAdGroupKeywordName of(String customer, String keywordPlanAdGroupKeyword) {
        return KeywordPlanAdGroupKeywordName.newBuilder().setCustomer(customer).setKeywordPlanAdGroupKeyword(keywordPlanAdGroupKeyword).build();
    }

    public static String format(String customer, String keywordPlanAdGroupKeyword) {
        return KeywordPlanAdGroupKeywordName.newBuilder().setCustomer(customer).setKeywordPlanAdGroupKeyword(keywordPlanAdGroupKeyword).build().toString();
    }

    public static KeywordPlanAdGroupKeywordName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "KeywordPlanAdGroupKeywordName.parse: formattedString not in valid format");
        return KeywordPlanAdGroupKeywordName.of((String)matchMap.get("customer"), (String)matchMap.get("keyword_plan_ad_group_keyword"));
    }

    public static List<KeywordPlanAdGroupKeywordName> parseList(List<String> formattedStrings) {
        ArrayList<KeywordPlanAdGroupKeywordName> list = new ArrayList<KeywordPlanAdGroupKeywordName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(KeywordPlanAdGroupKeywordName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<KeywordPlanAdGroupKeywordName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (KeywordPlanAdGroupKeywordName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            KeywordPlanAdGroupKeywordName keywordPlanAdGroupKeywordName = this;
            synchronized (keywordPlanAdGroupKeywordName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"keywordPlanAdGroupKeyword", (Object)this.keywordPlanAdGroupKeyword);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "keyword_plan_ad_group_keyword", this.keywordPlanAdGroupKeyword});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KeywordPlanAdGroupKeywordName) {
            KeywordPlanAdGroupKeywordName that = (KeywordPlanAdGroupKeywordName)o;
            return this.customer.equals(that.customer) && this.keywordPlanAdGroupKeyword.equals(that.keywordPlanAdGroupKeyword);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.keywordPlanAdGroupKeyword.hashCode();
    }

    public static class Builder {
        private String customer;
        private String keywordPlanAdGroupKeyword;

        public String getCustomer() {
            return this.customer;
        }

        public String getKeywordPlanAdGroupKeyword() {
            return this.keywordPlanAdGroupKeyword;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setKeywordPlanAdGroupKeyword(String keywordPlanAdGroupKeyword) {
            this.keywordPlanAdGroupKeyword = keywordPlanAdGroupKeyword;
            return this;
        }

        private Builder() {
        }

        private Builder(KeywordPlanAdGroupKeywordName keywordPlanAdGroupKeywordName) {
            this.customer = keywordPlanAdGroupKeywordName.customer;
            this.keywordPlanAdGroupKeyword = keywordPlanAdGroupKeywordName.keywordPlanAdGroupKeyword;
        }

        public KeywordPlanAdGroupKeywordName build() {
            return new KeywordPlanAdGroupKeywordName(this);
        }
    }
}

