/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class KeywordPlanAdGroupName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/keywordPlanAdGroups/{keyword_plan_ad_group}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String keywordPlanAdGroup;

    public String getCustomer() {
        return this.customer;
    }

    public String getKeywordPlanAdGroup() {
        return this.keywordPlanAdGroup;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private KeywordPlanAdGroupName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.keywordPlanAdGroup = (String)Preconditions.checkNotNull((Object)builder.getKeywordPlanAdGroup());
    }

    public static KeywordPlanAdGroupName of(String customer, String keywordPlanAdGroup) {
        return KeywordPlanAdGroupName.newBuilder().setCustomer(customer).setKeywordPlanAdGroup(keywordPlanAdGroup).build();
    }

    public static String format(String customer, String keywordPlanAdGroup) {
        return KeywordPlanAdGroupName.newBuilder().setCustomer(customer).setKeywordPlanAdGroup(keywordPlanAdGroup).build().toString();
    }

    public static KeywordPlanAdGroupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "KeywordPlanAdGroupName.parse: formattedString not in valid format");
        return KeywordPlanAdGroupName.of((String)matchMap.get("customer"), (String)matchMap.get("keyword_plan_ad_group"));
    }

    public static List<KeywordPlanAdGroupName> parseList(List<String> formattedStrings) {
        ArrayList<KeywordPlanAdGroupName> list = new ArrayList<KeywordPlanAdGroupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(KeywordPlanAdGroupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<KeywordPlanAdGroupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (KeywordPlanAdGroupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            KeywordPlanAdGroupName keywordPlanAdGroupName = this;
            synchronized (keywordPlanAdGroupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"keywordPlanAdGroup", (Object)this.keywordPlanAdGroup);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "keyword_plan_ad_group", this.keywordPlanAdGroup});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KeywordPlanAdGroupName) {
            KeywordPlanAdGroupName that = (KeywordPlanAdGroupName)o;
            return this.customer.equals(that.customer) && this.keywordPlanAdGroup.equals(that.keywordPlanAdGroup);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.keywordPlanAdGroup.hashCode();
    }

    public static class Builder {
        private String customer;
        private String keywordPlanAdGroup;

        public String getCustomer() {
            return this.customer;
        }

        public String getKeywordPlanAdGroup() {
            return this.keywordPlanAdGroup;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setKeywordPlanAdGroup(String keywordPlanAdGroup) {
            this.keywordPlanAdGroup = keywordPlanAdGroup;
            return this;
        }

        private Builder() {
        }

        private Builder(KeywordPlanAdGroupName keywordPlanAdGroupName) {
            this.customer = keywordPlanAdGroupName.customer;
            this.keywordPlanAdGroup = keywordPlanAdGroupName.keywordPlanAdGroup;
        }

        public KeywordPlanAdGroupName build() {
            return new KeywordPlanAdGroupName(this);
        }
    }
}

