/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class KeywordPlanCampaignKeywordName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/keywordPlanCampaignKeywords/{keyword_plan_campaign_keyword}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String keywordPlanCampaignKeyword;

    public String getCustomer() {
        return this.customer;
    }

    public String getKeywordPlanCampaignKeyword() {
        return this.keywordPlanCampaignKeyword;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private KeywordPlanCampaignKeywordName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.keywordPlanCampaignKeyword = (String)Preconditions.checkNotNull((Object)builder.getKeywordPlanCampaignKeyword());
    }

    public static KeywordPlanCampaignKeywordName of(String customer, String keywordPlanCampaignKeyword) {
        return KeywordPlanCampaignKeywordName.newBuilder().setCustomer(customer).setKeywordPlanCampaignKeyword(keywordPlanCampaignKeyword).build();
    }

    public static String format(String customer, String keywordPlanCampaignKeyword) {
        return KeywordPlanCampaignKeywordName.newBuilder().setCustomer(customer).setKeywordPlanCampaignKeyword(keywordPlanCampaignKeyword).build().toString();
    }

    public static KeywordPlanCampaignKeywordName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "KeywordPlanCampaignKeywordName.parse: formattedString not in valid format");
        return KeywordPlanCampaignKeywordName.of((String)matchMap.get("customer"), (String)matchMap.get("keyword_plan_campaign_keyword"));
    }

    public static List<KeywordPlanCampaignKeywordName> parseList(List<String> formattedStrings) {
        ArrayList<KeywordPlanCampaignKeywordName> list = new ArrayList<KeywordPlanCampaignKeywordName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(KeywordPlanCampaignKeywordName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<KeywordPlanCampaignKeywordName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (KeywordPlanCampaignKeywordName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            KeywordPlanCampaignKeywordName keywordPlanCampaignKeywordName = this;
            synchronized (keywordPlanCampaignKeywordName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"keywordPlanCampaignKeyword", (Object)this.keywordPlanCampaignKeyword);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "keyword_plan_campaign_keyword", this.keywordPlanCampaignKeyword});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KeywordPlanCampaignKeywordName) {
            KeywordPlanCampaignKeywordName that = (KeywordPlanCampaignKeywordName)o;
            return this.customer.equals(that.customer) && this.keywordPlanCampaignKeyword.equals(that.keywordPlanCampaignKeyword);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.keywordPlanCampaignKeyword.hashCode();
    }

    public static class Builder {
        private String customer;
        private String keywordPlanCampaignKeyword;

        public String getCustomer() {
            return this.customer;
        }

        public String getKeywordPlanCampaignKeyword() {
            return this.keywordPlanCampaignKeyword;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setKeywordPlanCampaignKeyword(String keywordPlanCampaignKeyword) {
            this.keywordPlanCampaignKeyword = keywordPlanCampaignKeyword;
            return this;
        }

        private Builder() {
        }

        private Builder(KeywordPlanCampaignKeywordName keywordPlanCampaignKeywordName) {
            this.customer = keywordPlanCampaignKeywordName.customer;
            this.keywordPlanCampaignKeyword = keywordPlanCampaignKeywordName.keywordPlanCampaignKeyword;
        }

        public KeywordPlanCampaignKeywordName build() {
            return new KeywordPlanCampaignKeywordName(this);
        }
    }
}

