/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class KeywordPlanCampaignName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/keywordPlanCampaigns/{keyword_plan_campaign}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String keywordPlanCampaign;

    public String getCustomer() {
        return this.customer;
    }

    public String getKeywordPlanCampaign() {
        return this.keywordPlanCampaign;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private KeywordPlanCampaignName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.keywordPlanCampaign = (String)Preconditions.checkNotNull((Object)builder.getKeywordPlanCampaign());
    }

    public static KeywordPlanCampaignName of(String customer, String keywordPlanCampaign) {
        return KeywordPlanCampaignName.newBuilder().setCustomer(customer).setKeywordPlanCampaign(keywordPlanCampaign).build();
    }

    public static String format(String customer, String keywordPlanCampaign) {
        return KeywordPlanCampaignName.newBuilder().setCustomer(customer).setKeywordPlanCampaign(keywordPlanCampaign).build().toString();
    }

    public static KeywordPlanCampaignName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "KeywordPlanCampaignName.parse: formattedString not in valid format");
        return KeywordPlanCampaignName.of((String)matchMap.get("customer"), (String)matchMap.get("keyword_plan_campaign"));
    }

    public static List<KeywordPlanCampaignName> parseList(List<String> formattedStrings) {
        ArrayList<KeywordPlanCampaignName> list = new ArrayList<KeywordPlanCampaignName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(KeywordPlanCampaignName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<KeywordPlanCampaignName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (KeywordPlanCampaignName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            KeywordPlanCampaignName keywordPlanCampaignName = this;
            synchronized (keywordPlanCampaignName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"keywordPlanCampaign", (Object)this.keywordPlanCampaign);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "keyword_plan_campaign", this.keywordPlanCampaign});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KeywordPlanCampaignName) {
            KeywordPlanCampaignName that = (KeywordPlanCampaignName)o;
            return this.customer.equals(that.customer) && this.keywordPlanCampaign.equals(that.keywordPlanCampaign);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.keywordPlanCampaign.hashCode();
    }

    public static class Builder {
        private String customer;
        private String keywordPlanCampaign;

        public String getCustomer() {
            return this.customer;
        }

        public String getKeywordPlanCampaign() {
            return this.keywordPlanCampaign;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setKeywordPlanCampaign(String keywordPlanCampaign) {
            this.keywordPlanCampaign = keywordPlanCampaign;
            return this;
        }

        private Builder() {
        }

        private Builder(KeywordPlanCampaignName keywordPlanCampaignName) {
            this.customer = keywordPlanCampaignName.customer;
            this.keywordPlanCampaign = keywordPlanCampaignName.keywordPlanCampaign;
        }

        public KeywordPlanCampaignName build() {
            return new KeywordPlanCampaignName(this);
        }
    }
}

