/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.ads.googleads.v5.resources.KeywordPlanCampaign;
import com.google.ads.googleads.v5.services.GetKeywordPlanCampaignRequest;
import com.google.ads.googleads.v5.services.KeywordPlanCampaignName;
import com.google.ads.googleads.v5.services.KeywordPlanCampaignOperation;
import com.google.ads.googleads.v5.services.KeywordPlanCampaignServiceSettings;
import com.google.ads.googleads.v5.services.MutateKeywordPlanCampaignsRequest;
import com.google.ads.googleads.v5.services.MutateKeywordPlanCampaignsResponse;
import com.google.ads.googleads.v5.services.stub.KeywordPlanCampaignServiceStub;
import com.google.ads.googleads.v5.services.stub.KeywordPlanCampaignServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class KeywordPlanCampaignServiceClient
implements BackgroundResource {
    private final KeywordPlanCampaignServiceSettings settings;
    private final KeywordPlanCampaignServiceStub stub;

    public static final KeywordPlanCampaignServiceClient create() throws IOException {
        return KeywordPlanCampaignServiceClient.create(KeywordPlanCampaignServiceSettings.newBuilder().build());
    }

    public static final KeywordPlanCampaignServiceClient create(KeywordPlanCampaignServiceSettings settings) throws IOException {
        return new KeywordPlanCampaignServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final KeywordPlanCampaignServiceClient create(KeywordPlanCampaignServiceStub stub) {
        return new KeywordPlanCampaignServiceClient(stub);
    }

    protected KeywordPlanCampaignServiceClient(KeywordPlanCampaignServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((KeywordPlanCampaignServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected KeywordPlanCampaignServiceClient(KeywordPlanCampaignServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final KeywordPlanCampaignServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public KeywordPlanCampaignServiceStub getStub() {
        return this.stub;
    }

    public final KeywordPlanCampaign getKeywordPlanCampaign(KeywordPlanCampaignName resourceName) {
        GetKeywordPlanCampaignRequest request = GetKeywordPlanCampaignRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getKeywordPlanCampaign(request);
    }

    public final KeywordPlanCampaign getKeywordPlanCampaign(String resourceName) {
        GetKeywordPlanCampaignRequest request = GetKeywordPlanCampaignRequest.newBuilder().setResourceName(resourceName).build();
        return this.getKeywordPlanCampaign(request);
    }

    public final KeywordPlanCampaign getKeywordPlanCampaign(GetKeywordPlanCampaignRequest request) {
        return (KeywordPlanCampaign)this.getKeywordPlanCampaignCallable().call((Object)request);
    }

    public final UnaryCallable<GetKeywordPlanCampaignRequest, KeywordPlanCampaign> getKeywordPlanCampaignCallable() {
        return this.stub.getKeywordPlanCampaignCallable();
    }

    public final MutateKeywordPlanCampaignsResponse mutateKeywordPlanCampaigns(String customerId, List<KeywordPlanCampaignOperation> operations) {
        MutateKeywordPlanCampaignsRequest request = MutateKeywordPlanCampaignsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateKeywordPlanCampaigns(request);
    }

    public final MutateKeywordPlanCampaignsResponse mutateKeywordPlanCampaigns(MutateKeywordPlanCampaignsRequest request) {
        return (MutateKeywordPlanCampaignsResponse)this.mutateKeywordPlanCampaignsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateKeywordPlanCampaignsRequest, MutateKeywordPlanCampaignsResponse> mutateKeywordPlanCampaignsCallable() {
        return this.stub.mutateKeywordPlanCampaignsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

