/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class KeywordPlanName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/keywordPlans/{keyword_plan}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String keywordPlan;

    public String getCustomer() {
        return this.customer;
    }

    public String getKeywordPlan() {
        return this.keywordPlan;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private KeywordPlanName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.keywordPlan = (String)Preconditions.checkNotNull((Object)builder.getKeywordPlan());
    }

    public static KeywordPlanName of(String customer, String keywordPlan) {
        return KeywordPlanName.newBuilder().setCustomer(customer).setKeywordPlan(keywordPlan).build();
    }

    public static String format(String customer, String keywordPlan) {
        return KeywordPlanName.newBuilder().setCustomer(customer).setKeywordPlan(keywordPlan).build().toString();
    }

    public static KeywordPlanName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "KeywordPlanName.parse: formattedString not in valid format");
        return KeywordPlanName.of((String)matchMap.get("customer"), (String)matchMap.get("keyword_plan"));
    }

    public static List<KeywordPlanName> parseList(List<String> formattedStrings) {
        ArrayList<KeywordPlanName> list = new ArrayList<KeywordPlanName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(KeywordPlanName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<KeywordPlanName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (KeywordPlanName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            KeywordPlanName keywordPlanName = this;
            synchronized (keywordPlanName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"keywordPlan", (Object)this.keywordPlan);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "keyword_plan", this.keywordPlan});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KeywordPlanName) {
            KeywordPlanName that = (KeywordPlanName)o;
            return this.customer.equals(that.customer) && this.keywordPlan.equals(that.keywordPlan);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.keywordPlan.hashCode();
    }

    public static class Builder {
        private String customer;
        private String keywordPlan;

        public String getCustomer() {
            return this.customer;
        }

        public String getKeywordPlan() {
            return this.keywordPlan;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setKeywordPlan(String keywordPlan) {
            this.keywordPlan = keywordPlan;
            return this;
        }

        private Builder() {
        }

        private Builder(KeywordPlanName keywordPlanName) {
            this.customer = keywordPlanName.customer;
            this.keywordPlan = keywordPlanName.keywordPlan;
        }

        public KeywordPlanName build() {
            return new KeywordPlanName(this);
        }
    }
}

