/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.ads.googleads.v5.resources.KeywordPlan;
import com.google.ads.googleads.v5.services.GenerateForecastCurveRequest;
import com.google.ads.googleads.v5.services.GenerateForecastCurveResponse;
import com.google.ads.googleads.v5.services.GenerateForecastMetricsRequest;
import com.google.ads.googleads.v5.services.GenerateForecastMetricsResponse;
import com.google.ads.googleads.v5.services.GenerateForecastTimeSeriesRequest;
import com.google.ads.googleads.v5.services.GenerateForecastTimeSeriesResponse;
import com.google.ads.googleads.v5.services.GenerateHistoricalMetricsRequest;
import com.google.ads.googleads.v5.services.GenerateHistoricalMetricsResponse;
import com.google.ads.googleads.v5.services.GetKeywordPlanRequest;
import com.google.ads.googleads.v5.services.KeywordPlanName;
import com.google.ads.googleads.v5.services.KeywordPlanOperation;
import com.google.ads.googleads.v5.services.KeywordPlanServiceSettings;
import com.google.ads.googleads.v5.services.MutateKeywordPlansRequest;
import com.google.ads.googleads.v5.services.MutateKeywordPlansResponse;
import com.google.ads.googleads.v5.services.stub.KeywordPlanServiceStub;
import com.google.ads.googleads.v5.services.stub.KeywordPlanServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class KeywordPlanServiceClient
implements BackgroundResource {
    private final KeywordPlanServiceSettings settings;
    private final KeywordPlanServiceStub stub;

    public static final KeywordPlanServiceClient create() throws IOException {
        return KeywordPlanServiceClient.create(KeywordPlanServiceSettings.newBuilder().build());
    }

    public static final KeywordPlanServiceClient create(KeywordPlanServiceSettings settings) throws IOException {
        return new KeywordPlanServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final KeywordPlanServiceClient create(KeywordPlanServiceStub stub) {
        return new KeywordPlanServiceClient(stub);
    }

    protected KeywordPlanServiceClient(KeywordPlanServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((KeywordPlanServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected KeywordPlanServiceClient(KeywordPlanServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final KeywordPlanServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public KeywordPlanServiceStub getStub() {
        return this.stub;
    }

    public final KeywordPlan getKeywordPlan(KeywordPlanName resourceName) {
        GetKeywordPlanRequest request = GetKeywordPlanRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getKeywordPlan(request);
    }

    public final KeywordPlan getKeywordPlan(String resourceName) {
        GetKeywordPlanRequest request = GetKeywordPlanRequest.newBuilder().setResourceName(resourceName).build();
        return this.getKeywordPlan(request);
    }

    public final KeywordPlan getKeywordPlan(GetKeywordPlanRequest request) {
        return (KeywordPlan)this.getKeywordPlanCallable().call((Object)request);
    }

    public final UnaryCallable<GetKeywordPlanRequest, KeywordPlan> getKeywordPlanCallable() {
        return this.stub.getKeywordPlanCallable();
    }

    public final MutateKeywordPlansResponse mutateKeywordPlans(String customerId, List<KeywordPlanOperation> operations) {
        MutateKeywordPlansRequest request = MutateKeywordPlansRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateKeywordPlans(request);
    }

    public final MutateKeywordPlansResponse mutateKeywordPlans(MutateKeywordPlansRequest request) {
        return (MutateKeywordPlansResponse)this.mutateKeywordPlansCallable().call((Object)request);
    }

    public final UnaryCallable<MutateKeywordPlansRequest, MutateKeywordPlansResponse> mutateKeywordPlansCallable() {
        return this.stub.mutateKeywordPlansCallable();
    }

    public final GenerateForecastCurveResponse generateForecastCurve(KeywordPlanName keywordPlan) {
        GenerateForecastCurveRequest request = GenerateForecastCurveRequest.newBuilder().setKeywordPlan(keywordPlan == null ? null : keywordPlan.toString()).build();
        return this.generateForecastCurve(request);
    }

    public final GenerateForecastCurveResponse generateForecastCurve(String keywordPlan) {
        GenerateForecastCurveRequest request = GenerateForecastCurveRequest.newBuilder().setKeywordPlan(keywordPlan).build();
        return this.generateForecastCurve(request);
    }

    public final GenerateForecastCurveResponse generateForecastCurve(GenerateForecastCurveRequest request) {
        return (GenerateForecastCurveResponse)this.generateForecastCurveCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateForecastCurveRequest, GenerateForecastCurveResponse> generateForecastCurveCallable() {
        return this.stub.generateForecastCurveCallable();
    }

    public final GenerateForecastTimeSeriesResponse generateForecastTimeSeries(KeywordPlanName keywordPlan) {
        GenerateForecastTimeSeriesRequest request = GenerateForecastTimeSeriesRequest.newBuilder().setKeywordPlan(keywordPlan == null ? null : keywordPlan.toString()).build();
        return this.generateForecastTimeSeries(request);
    }

    public final GenerateForecastTimeSeriesResponse generateForecastTimeSeries(String keywordPlan) {
        GenerateForecastTimeSeriesRequest request = GenerateForecastTimeSeriesRequest.newBuilder().setKeywordPlan(keywordPlan).build();
        return this.generateForecastTimeSeries(request);
    }

    public final GenerateForecastTimeSeriesResponse generateForecastTimeSeries(GenerateForecastTimeSeriesRequest request) {
        return (GenerateForecastTimeSeriesResponse)this.generateForecastTimeSeriesCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateForecastTimeSeriesRequest, GenerateForecastTimeSeriesResponse> generateForecastTimeSeriesCallable() {
        return this.stub.generateForecastTimeSeriesCallable();
    }

    public final GenerateForecastMetricsResponse generateForecastMetrics(KeywordPlanName keywordPlan) {
        GenerateForecastMetricsRequest request = GenerateForecastMetricsRequest.newBuilder().setKeywordPlan(keywordPlan == null ? null : keywordPlan.toString()).build();
        return this.generateForecastMetrics(request);
    }

    public final GenerateForecastMetricsResponse generateForecastMetrics(String keywordPlan) {
        GenerateForecastMetricsRequest request = GenerateForecastMetricsRequest.newBuilder().setKeywordPlan(keywordPlan).build();
        return this.generateForecastMetrics(request);
    }

    public final GenerateForecastMetricsResponse generateForecastMetrics(GenerateForecastMetricsRequest request) {
        return (GenerateForecastMetricsResponse)this.generateForecastMetricsCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateForecastMetricsRequest, GenerateForecastMetricsResponse> generateForecastMetricsCallable() {
        return this.stub.generateForecastMetricsCallable();
    }

    public final GenerateHistoricalMetricsResponse generateHistoricalMetrics(KeywordPlanName keywordPlan) {
        GenerateHistoricalMetricsRequest request = GenerateHistoricalMetricsRequest.newBuilder().setKeywordPlan(keywordPlan == null ? null : keywordPlan.toString()).build();
        return this.generateHistoricalMetrics(request);
    }

    public final GenerateHistoricalMetricsResponse generateHistoricalMetrics(String keywordPlan) {
        GenerateHistoricalMetricsRequest request = GenerateHistoricalMetricsRequest.newBuilder().setKeywordPlan(keywordPlan).build();
        return this.generateHistoricalMetrics(request);
    }

    public final GenerateHistoricalMetricsResponse generateHistoricalMetrics(GenerateHistoricalMetricsRequest request) {
        return (GenerateHistoricalMetricsResponse)this.generateHistoricalMetricsCallable().call((Object)request);
    }

    public final UnaryCallable<GenerateHistoricalMetricsRequest, GenerateHistoricalMetricsResponse> generateHistoricalMetricsCallable() {
        return this.stub.generateHistoricalMetricsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

