/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class KeywordViewName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer}/keywordViews/{keyword_view}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customer;
    private final String keywordView;

    public String getCustomer() {
        return this.customer;
    }

    public String getKeywordView() {
        return this.keywordView;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private KeywordViewName(Builder builder) {
        this.customer = (String)Preconditions.checkNotNull((Object)builder.getCustomer());
        this.keywordView = (String)Preconditions.checkNotNull((Object)builder.getKeywordView());
    }

    public static KeywordViewName of(String customer, String keywordView) {
        return KeywordViewName.newBuilder().setCustomer(customer).setKeywordView(keywordView).build();
    }

    public static String format(String customer, String keywordView) {
        return KeywordViewName.newBuilder().setCustomer(customer).setKeywordView(keywordView).build().toString();
    }

    public static KeywordViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "KeywordViewName.parse: formattedString not in valid format");
        return KeywordViewName.of((String)matchMap.get("customer"), (String)matchMap.get("keyword_view"));
    }

    public static List<KeywordViewName> parseList(List<String> formattedStrings) {
        ArrayList<KeywordViewName> list = new ArrayList<KeywordViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(KeywordViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<KeywordViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (KeywordViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            KeywordViewName keywordViewName = this;
            synchronized (keywordViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"customer", (Object)this.customer);
                    fieldMapBuilder.put((Object)"keywordView", (Object)this.keywordView);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"customer", this.customer, "keyword_view", this.keywordView});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof KeywordViewName) {
            KeywordViewName that = (KeywordViewName)o;
            return this.customer.equals(that.customer) && this.keywordView.equals(that.keywordView);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.customer.hashCode();
        h *= 1000003;
        return h ^= this.keywordView.hashCode();
    }

    public static class Builder {
        private String customer;
        private String keywordView;

        public String getCustomer() {
            return this.customer;
        }

        public String getKeywordView() {
            return this.keywordView;
        }

        public Builder setCustomer(String customer) {
            this.customer = customer;
            return this;
        }

        public Builder setKeywordView(String keywordView) {
            this.keywordView = keywordView;
            return this;
        }

        private Builder() {
        }

        private Builder(KeywordViewName keywordViewName) {
            this.customer = keywordViewName.customer;
            this.keywordView = keywordViewName.keywordView;
        }

        public KeywordViewName build() {
            return new KeywordViewName(this);
        }
    }
}

