/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v5.services;

import com.google.ads.googleads.v5.resources.KeywordView;
import com.google.ads.googleads.v5.services.GetKeywordViewRequest;
import com.google.ads.googleads.v5.services.KeywordViewName;
import com.google.ads.googleads.v5.services.KeywordViewServiceSettings;
import com.google.ads.googleads.v5.services.stub.KeywordViewServiceStub;
import com.google.ads.googleads.v5.services.stub.KeywordViewServiceStubSettings;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class KeywordViewServiceClient
implements BackgroundResource {
    private final KeywordViewServiceSettings settings;
    private final KeywordViewServiceStub stub;

    public static final KeywordViewServiceClient create() throws IOException {
        return KeywordViewServiceClient.create(KeywordViewServiceSettings.newBuilder().build());
    }

    public static final KeywordViewServiceClient create(KeywordViewServiceSettings settings) throws IOException {
        return new KeywordViewServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final KeywordViewServiceClient create(KeywordViewServiceStub stub) {
        return new KeywordViewServiceClient(stub);
    }

    protected KeywordViewServiceClient(KeywordViewServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((KeywordViewServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected KeywordViewServiceClient(KeywordViewServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final KeywordViewServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public KeywordViewServiceStub getStub() {
        return this.stub;
    }

    public final KeywordView getKeywordView(KeywordViewName resourceName) {
        GetKeywordViewRequest request = GetKeywordViewRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getKeywordView(request);
    }

    public final KeywordView getKeywordView(String resourceName) {
        GetKeywordViewRequest request = GetKeywordViewRequest.newBuilder().setResourceName(resourceName).build();
        return this.getKeywordView(request);
    }

    public final KeywordView getKeywordView(GetKeywordViewRequest request) {
        return (KeywordView)this.getKeywordViewCallable().call((Object)request);
    }

    public final UnaryCallable<GetKeywordViewRequest, KeywordView> getKeywordViewCallable() {
        return this.stub.getKeywordViewCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

